/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.controllers;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.AddressRecord;
import de.inahware.dav.models.Address;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.sql.SQLDataController;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class AddressController
extends SQLDataController<Address, AddressRecord, ClientRequestContext> {
    @Override
    public DataModel<Address> getModel() {
        return Address.MODEL;
    }

    @Override
    public Table<AddressRecord> getTable() {
        return Tables.ADDRESS;
    }

    @Override
    public List<Address> onSelectAll(ClientRequestContext ctx, Filter filter, int offset, int limit) throws Exception {
        Address.GUARD.onSelectAll(ctx, filter, offset, limit);
        return super.selectAll(ctx, filter, offset, limit);
    }

    @Override
    public List<Address> onInsertAll(ClientRequestContext ctx, List<Address> objs) throws Exception {
        Address.GUARD.onInsertAll(ctx, objs);
        return super.insertAll(ctx, objs);
    }

    @Override
    public void onUpdate(ClientRequestContext ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        Address.GUARD.onUpdate(ctx, fields, filter);
        ctx.transaction(dsl -> {
            Condition addr_cond;
            Condition cond = super.buildCondition((DSLContext)dsl, filter);
            super.update((DSLContext)dsl, fields, cond);
            Address addr = dsl.selectFrom(Tables.ADDRESS).where(cond).fetchAnyInto(Address.class);
            Condition condition = addr_cond = addr.getCustomerId() != null ? Address.COL_CUSTOMER_ID.eq((DSLContext)dsl, addr.getCustomerId()) : Address.COL_VENDOR_ID.eq((DSLContext)dsl, addr.getVendorId());
            if (addr.isDefaultAddress().booleanValue()) {
                dsl.update(Tables.ADDRESS).set(Address.COL_DEFAULT_ADDRESS.set((DSLContext)dsl, false)).where(DSL.not(Address.COL_ID.eq((DSLContext)dsl, addr.getId())), addr_cond).execute();
            }
            if (addr.isDefaultShippingAddress().booleanValue()) {
                dsl.update(Tables.ADDRESS).set(Address.COL_DEFAULT_SHIPPING_ADDRESS.set((DSLContext)dsl, false)).where(DSL.not(Address.COL_ID.eq((DSLContext)dsl, addr.getId())), addr_cond).execute();
            }
        });
    }

    @Override
    public void onDelete(ClientRequestContext ctx, Filter filter) throws Exception {
        Address.GUARD.onDelete(ctx, filter);
        super.delete(ctx, filter);
    }
}

