/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.controllers;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.ArticleRecord;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.requests.AttachmentUtils;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.sql.SQLDataController;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Table;

public class ArticleController
extends SQLDataController<Article, ArticleRecord, ClientRequestContext> {
    @Override
    public DataModel<Article> getModel() {
        return Article.MODEL;
    }

    @Override
    public Table<ArticleRecord> getTable() {
        return Tables.ARTICLE;
    }

    @Override
    public List<Article> onSelectAll(ClientRequestContext ctx, Filter filter, int offset, int limit) throws Exception {
        Article.GUARD.onSelectAll(ctx, filter, offset, limit);
        return super.selectAll(ctx, filter, offset, limit);
    }

    @Override
    public List<Article> onInsertAll(ClientRequestContext ctx, List<Article> objs) throws Exception {
        Article.GUARD.onInsertAll(ctx, objs);
        return super.insertAll(ctx, objs);
    }

    @Override
    public void onUpdate(ClientRequestContext ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        Article.GUARD.onUpdate(ctx, fields, filter);
        super.update(ctx, fields, filter);
    }

    @Override
    public void onDelete(ClientRequestContext ctx, Filter filter) throws Exception {
        Article.GUARD.onDelete(ctx, filter);
        ctx.transaction(dsl -> {
            Condition cond = this.buildCondition((DSLContext)dsl, filter);
            Article obj = dsl.selectFrom(Tables.ARTICLE).where(cond).fetchAnyInto(Article.class);
            if (obj == null) {
                return;
            }
            super.delete((DSLContext)dsl, cond);
            AttachmentUtils.delete(ctx, dsl, AttachmentObjectType.ARTICLE, obj.getId());
        });
    }
}

