/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.controllers;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.AttachmentRecord;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.requests.AttachmentUtils;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.request.RequestException;
import de.inahware.edvj.sql.SQLDataController;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Table;

public class AttachmentController
extends SQLDataController<Attachment, AttachmentRecord, ClientRequestContext> {
    @Override
    public DataModel<Attachment> getModel() {
        return Attachment.MODEL;
    }

    @Override
    public Table<AttachmentRecord> getTable() {
        return Tables.ATTACHMENT;
    }

    @Override
    public List<Attachment> onSelectAll(ClientRequestContext ctx, Filter filter, int offset, int limit) throws Exception {
        Attachment.GUARD.onSelectAll(ctx, filter, offset, limit);
        return super.selectAll(ctx, filter, offset, limit);
    }

    @Override
    public List<Attachment> onInsertAll(ClientRequestContext ctx, List<Attachment> objs) throws Exception {
        Attachment.GUARD.onInsertAll(ctx, objs);
        if (objs.size() == 0) {
            return List.of();
        }
        return ctx.transactionResult(dsl -> {
            ((Attachment)objs.get(0)).setRefCount(0L);
            ((Attachment)objs.get(0)).setLockCount(0L);
            List res = super.insertAll((DSLContext)dsl, objs);
            Attachment att = (Attachment)res.get(0);
            switch (att.getType()) {
                case TEXT: 
                case OTHER: {
                    break;
                }
                case FILE: {
                    Path tempFile = ctx.getSession().getUploadedFile();
                    if (tempFile == null) {
                        throw new RequestException();
                    }
                    ctx.getSession().setUploadedFile(null);
                    try {
                        if (att.getFilesize() != Files.size(tempFile)) {
                            throw new RequestException();
                        }
                        Path dest = ctx.getStoragePath().resolve(att.getPath());
                        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                        Files.move(tempFile, dest, new CopyOption[0]);
                        break;
                    }
                    catch (Exception ex) {
                        Files.deleteIfExists(tempFile);
                        throw ex;
                    }
                }
            }
            return res;
        });
    }

    @Override
    public void onUpdate(ClientRequestContext ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        Attachment.GUARD.onUpdate(ctx, fields, filter);
        ctx.transaction(dsl -> {
            Condition cond = this.buildCondition((DSLContext)dsl, filter);
            Attachment attachment = dsl.selectFrom(Tables.ATTACHMENT).where(cond).fetchAnyInto(Attachment.class);
            if (attachment == null || attachment.getLockCount() != 0L) {
                throw new RequestException();
            }
            switch (attachment.getType()) {
                case TEXT: 
                case OTHER: {
                    super.update((DSLContext)dsl, fields, cond);
                    break;
                }
                case FILE: {
                    Path tempFile = ctx.getSession().getUploadedFile();
                    if (tempFile != null) {
                        try {
                            ctx.getSession().setUploadedFile(null);
                            Path oldPath = ctx.getStoragePath().resolve(attachment.getPath());
                            super.update((DSLContext)dsl, fields, attachment, cond);
                            if (attachment.getFilesize() != Files.size(tempFile)) {
                                throw new RequestException();
                            }
                            Path dest = ctx.getStoragePath().resolve(attachment.getPath());
                            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                            Files.move(tempFile, dest, StandardCopyOption.REPLACE_EXISTING);
                            if (dest.equals(oldPath)) break;
                            oldPath.toFile().delete();
                            break;
                        }
                        catch (Exception ex) {
                            Files.deleteIfExists(tempFile);
                            throw ex;
                        }
                    }
                    super.update((DSLContext)dsl, fields, cond);
                }
            }
        });
    }

    @Override
    public void onDelete(ClientRequestContext ctx, Filter filter) throws Exception {
        Attachment.GUARD.onDelete(ctx, filter);
        ctx.transaction(dsl -> {
            Condition cond = this.buildCondition((DSLContext)dsl, filter);
            Attachment att = dsl.selectFrom(Tables.ATTACHMENT).where(cond).fetchAnyInto(Attachment.class);
            if (att == null) {
                return;
            }
            super.delete((DSLContext)dsl, cond);
            AttachmentUtils.delete(ctx, dsl, att);
        });
    }
}

