/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.controllers;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.BankStatementItemRecord;
import de.inahware.dav.jooq.tables.records.BankStatementRecord;
import de.inahware.dav.models.BankStatement;
import de.inahware.dav.models.BankStatementFull;
import de.inahware.dav.models.BankStatementItem;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.requests.AttachmentUtils;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.request.RequestException;
import de.inahware.edvj.sql.SQLDataController;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Table;

public class BankStatementFullController
extends SQLDataController<BankStatementFull, BankStatementRecord, ClientRequestContext> {
    @Override
    public DataModel<BankStatementFull> getModel() {
        return BankStatementFull.MODEL;
    }

    @Override
    public Table<BankStatementRecord> getTable() {
        return Tables.BANK_STATEMENT;
    }

    @Override
    public List<BankStatementFull> onSelectAll(ClientRequestContext ctx, Filter filter, int offset, int limit) throws Exception {
        BankStatementFull.GUARD.onSelectAll(ctx, filter, offset, limit);
        return ctx.transactionResult(dsl -> {
            List res = super.selectAll((DSLContext)dsl, filter, offset, limit);
            for (BankStatementFull obj : res) {
                obj.queryFull((DSLContext)dsl);
            }
            return res;
        });
    }

    @Override
    public List<BankStatementFull> onInsertAll(ClientRequestContext ctx, List<BankStatementFull> objs) throws Exception {
        BankStatementFull.GUARD.onInsertAll(ctx, objs);
        return ctx.transactionResult(dsl -> {
            List res = super.insertAll((DSLContext)dsl, objs);
            for (BankStatementFull obj : res) {
                for (BankStatementItem item : obj.getItems()) {
                    if (item.getBankStatementId() != null) {
                        throw new RequestException();
                    }
                    item.setBankStatementId(obj.getId());
                    BankStatementItemRecord record = dsl.newRecord(Tables.BANK_STATEMENT_ITEM, item);
                    record.insert();
                    record.into(item);
                }
            }
            return res;
        });
    }

    @Override
    public void onUpdate(ClientRequestContext ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        BankStatementFull.GUARD.onUpdate(ctx, fields, filter);
        ctx.transaction(dsl -> {
            Condition cond = this.buildCondition((DSLContext)dsl, filter);
            BankStatementFull obj = dsl.selectFrom(Tables.BANK_STATEMENT).where(cond).fetchAnyInto(BankStatementFull.class);
            obj.queryFull((DSLContext)dsl);
            if (obj.getAttachmentId() != null) {
                AttachmentUtils.decRef(dsl, obj.getAttachmentId());
            }
            Set<DataColumn<?>> cols = this.getUpdateColumns(fields);
            obj.update(fields);
            super.update((DSLContext)dsl, cols, obj, cond);
            if (cols.contains(BankStatementFull.COL_ITEMS)) {
                for (BankStatementItem item : obj.getItems()) {
                    BankStatementItemRecord record;
                    if (item.getId() == null) {
                        if (item.getBankStatementId() != null) {
                            throw new RequestException();
                        }
                        item.setBankStatementId(obj.getId());
                        record = dsl.newRecord(Tables.BANK_STATEMENT_ITEM, item);
                        record.insert();
                        record.into(item);
                        continue;
                    }
                    if (item.getBankStatementId().longValue() != obj.getId().longValue()) {
                        throw new RequestException();
                    }
                    record = dsl.newRecord(Tables.BANK_STATEMENT_ITEM, item);
                    record.update();
                    record.into(item);
                }
                HashSet<Long> delete = new HashSet<Long>();
                for (BankStatementItem item : obj.getItems()) {
                    delete.add(item.getId());
                }
                for (BankStatementItem item : obj.getItems()) {
                    delete.remove(item.getId());
                }
                dsl.deleteFrom(Tables.BANK_STATEMENT_ITEM).where(BankStatementItem.COL_ID.in((DSLContext)dsl, (Collection<Long>)delete)).execute();
            }
            if (obj.getAttachmentId() != null) {
                AttachmentUtils.incRef(dsl, obj.getAttachmentId());
            }
        });
    }

    @Override
    public void onDelete(ClientRequestContext ctx, Filter filter) throws Exception {
        BankStatementFull.GUARD.onDelete(ctx, filter);
        ctx.transaction(dsl -> {
            Condition cond = this.buildCondition((DSLContext)dsl, filter);
            BankStatement obj = dsl.selectFrom(Tables.BANK_STATEMENT).where(cond).fetchAnyInto(BankStatement.class);
            if (obj == null) {
                return;
            }
            super.delete((DSLContext)dsl, cond);
            AttachmentUtils.delete(ctx, dsl, AttachmentObjectType.BANKSTATEMENT, obj.getId());
        });
    }
}

