/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.controllers;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.DocumentDocumentRecord;
import de.inahware.dav.jooq.tables.records.DocumentRecord;
import de.inahware.dav.jooq.tables.records.OrderDocumentRecord;
import de.inahware.dav.models.Counter;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.requests.AttachmentUtils;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.dav.requests.DocumentUtils;
import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.sql.SQLDataController;
import java.util.List;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Table;
import org.jooq.impl.UpdatableRecordImpl;

public class DocumentFullController
extends SQLDataController<DocumentFull, DocumentRecord, ClientRequestContext> {
    @Override
    public DataModel<DocumentFull> getModel() {
        return DocumentFull.MODEL;
    }

    @Override
    public Table<DocumentRecord> getTable() {
        return Tables.DOCUMENT;
    }

    @Override
    public List<DocumentFull> onSelectAll(ClientRequestContext ctx, Filter filter, int offset, int limit) throws Exception {
        DocumentFull.GUARD.onSelectAll(ctx, filter, offset, limit);
        return ctx.transactionResult(dsl -> {
            List res = super.selectAll((DSLContext)dsl, filter, offset, limit);
            for (DocumentFull document : res) {
                document.queryFullDocument((DSLContext)dsl);
            }
            return res;
        });
    }

    @Override
    public List<DocumentFull> onInsertAll(ClientRequestContext ctx, List<DocumentFull> objs) throws Exception {
        DocumentFull.GUARD.onInsertAll(ctx, objs);
        return ctx.transactionResult(dsl -> {
            Counter counter = dsl.selectFrom(Tables.COUNTER).where(Tables.COUNTER.NAME.eq("Document.DRAFT")).forUpdate().fetchAnyInto(Counter.class);
            for (DocumentFull obj : objs) {
                String number = counter.generateNext();
                obj.setState(OrderState.DRAFT);
                obj.setNumber(number);
            }
            dsl.newRecord(Tables.COUNTER, counter).update(Tables.COUNTER.LAST_PREFIX, Tables.COUNTER.COUNT);
            List res = super.insertAll((DSLContext)dsl, objs);
            for (DocumentFull obj : res) {
                UpdatableRecordImpl record;
                for (Long id : obj.getOrders()) {
                    record = dsl.newRecord(Tables.ORDER_DOCUMENT);
                    ((OrderDocumentRecord)record).setOrderId(id);
                    ((OrderDocumentRecord)record).setDocumentId(obj.getId());
                    record.insert();
                }
                for (Long id : obj.getParents()) {
                    record = dsl.newRecord(Tables.DOCUMENT_DOCUMENT);
                    ((DocumentDocumentRecord)record).setParentDocumentId(id);
                    ((DocumentDocumentRecord)record).setChildDocumentId(obj.getId());
                    record.insert();
                }
                DocumentUtils.updateItems(dsl, obj, obj.getItems());
                DocumentUtils.updateDeductions(dsl, obj, obj.getDeductions());
            }
            return res;
        });
    }

    @Override
    public void onUpdate(ClientRequestContext ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        DocumentFull.GUARD.onUpdate(ctx, fields, filter);
        ctx.transaction(dsl -> {
            Condition cond = this.buildCondition((DSLContext)dsl, filter);
            DocumentFull document = dsl.selectFrom(Tables.DOCUMENT).where(cond).fetchAnyInto(DocumentFull.class);
            document.queryFullDocument((DSLContext)dsl);
            if (document.getAttachmentId() != null) {
                AttachmentUtils.decRefLock(dsl, document.getAttachmentId());
            }
            if (document.getHeadlessAttachmentId() != null) {
                AttachmentUtils.decRefLock(dsl, document.getHeadlessAttachmentId());
            }
            Set<DataColumn<?>> cols = this.getUpdateColumns(fields);
            document.update(fields);
            super.update((DSLContext)dsl, cols, document, cond);
            if (cols.contains(DocumentFull.COL_ITEMS)) {
                DocumentUtils.updateItems(dsl, document, document.getItems());
            }
            if (cols.contains(DocumentFull.COL_DEDUCTIONS)) {
                DocumentUtils.updateDeductions(dsl, document, document.getDeductions());
            }
            if (document.getAttachmentId() != null) {
                AttachmentUtils.incRefLock(dsl, document.getAttachmentId());
            }
            if (document.getHeadlessAttachmentId() != null) {
                AttachmentUtils.incRefLock(dsl, document.getHeadlessAttachmentId());
            }
        });
    }

    @Override
    public void onDelete(ClientRequestContext ctx, Filter filter) throws Exception {
        DocumentFull.GUARD.onDelete(ctx, filter);
        ctx.transaction(dsl -> {
            Condition cond = this.buildCondition((DSLContext)dsl, filter);
            Document obj = dsl.selectFrom(Tables.DOCUMENT).where(cond).fetchAnyInto(Document.class);
            if (obj == null) {
                return;
            }
            super.delete((DSLContext)dsl, cond);
            AttachmentUtils.delete(ctx, dsl, AttachmentObjectType.DOCUMENT, obj.getId());
        });
    }
}

