/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.controllers;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.NoticeRecord;
import de.inahware.dav.models.Notice;
import de.inahware.dav.models.PendingNotice;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.sql.SQLDataController;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Table;

public class NoticeController
extends SQLDataController<Notice, NoticeRecord, ClientRequestContext> {
    @Override
    public DataModel<Notice> getModel() {
        return Notice.MODEL;
    }

    @Override
    public Table<NoticeRecord> getTable() {
        return Tables.NOTICE;
    }

    @Override
    public List<Notice> onSelectAll(ClientRequestContext ctx, Filter filter, int offset, int limit) throws Exception {
        Notice.GUARD.onSelectAll(ctx, filter, offset, limit);
        return super.selectAll(ctx, filter, offset, limit);
    }

    @Override
    public List<Notice> onInsertAll(ClientRequestContext ctx, List<Notice> objs) throws Exception {
        Notice.GUARD.onInsertAll(ctx, objs);
        return ctx.transactionResult(dsl -> {
            for (Notice obj : objs) {
                obj.setState(OrderState.DRAFT);
                obj.setAttachmentId(null);
                obj.setHeadlessAttachmentId(null);
                obj.setPrinted(0L);
            }
            List res = super.insertAll((DSLContext)dsl, objs);
            for (Notice obj : res) {
                if (obj.getDocumentId() == null) continue;
                dsl.deleteFrom(Tables.PENDING_NOTICE).where(PendingNotice.COL_DOCUMENT_ID.eq((DSLContext)dsl, obj.getDocumentId())).execute();
            }
            return res;
        });
    }

    @Override
    public void onUpdate(ClientRequestContext ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        Notice.GUARD.onUpdate(ctx, fields, filter);
        super.update(ctx, fields, filter);
    }
}

