/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.controllers;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.RecordRecord;
import de.inahware.dav.models.Record;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.requests.AttachmentUtils;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.sql.SQLDataController;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Table;

public class RecordController
extends SQLDataController<Record, RecordRecord, ClientRequestContext> {
    @Override
    public DataModel<Record> getModel() {
        return Record.MODEL;
    }

    @Override
    public Table<RecordRecord> getTable() {
        return Tables.RECORD;
    }

    @Override
    public List<Record> onSelectAll(ClientRequestContext ctx, Filter filter, int offset, int limit) throws Exception {
        Record.GUARD.onSelectAll(ctx, filter, offset, limit);
        return super.selectAll(ctx, filter, offset, limit);
    }

    @Override
    public List<Record> onInsertAll(ClientRequestContext ctx, List<Record> objs) throws Exception {
        Record.GUARD.onInsertAll(ctx, objs);
        return super.insertAll(ctx, objs);
    }

    @Override
    public void onUpdate(ClientRequestContext ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        Record.GUARD.onUpdate(ctx, fields, filter);
        ctx.transaction(dsl -> {
            Condition cond = this.buildCondition((DSLContext)dsl, filter);
            Record obj = dsl.selectFrom(Tables.RECORD).where(cond).fetchAnyInto(Record.class);
            if (obj.getAttachmentId() != null) {
                AttachmentUtils.decRef(dsl, obj.getAttachmentId());
            }
            obj.update(fields);
            super.update((DSLContext)dsl, fields, obj, cond);
            if (obj.getAttachmentId() != null) {
                AttachmentUtils.incRef(dsl, obj.getAttachmentId());
            }
        });
    }

    @Override
    public void onDelete(ClientRequestContext ctx, Filter filter) throws Exception {
        Record.GUARD.onDelete(ctx, filter);
        ctx.transaction(dsl -> {
            Condition cond = this.buildCondition((DSLContext)dsl, filter);
            Record obj = dsl.selectFrom(Tables.RECORD).where(cond).fetchAnyInto(Record.class);
            if (obj == null) {
                return;
            }
            super.delete((DSLContext)dsl, cond);
            AttachmentUtils.delete(ctx, dsl, AttachmentObjectType.RECORD, obj.getId());
        });
    }
}

