/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.controllers;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.TaskRecord;
import de.inahware.dav.models.Task;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.requests.AttachmentUtils;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.sql.SQLDataController;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Table;

public class TaskController
extends SQLDataController<Task, TaskRecord, ClientRequestContext> {
    @Override
    public DataModel<Task> getModel() {
        return Task.MODEL;
    }

    @Override
    public Table<TaskRecord> getTable() {
        return Tables.TASK;
    }

    @Override
    public List<Task> onSelectAll(ClientRequestContext ctx, Filter filter, int offset, int limit) throws Exception {
        Task.GUARD.onSelectAll(ctx, filter, offset, limit);
        return super.selectAll(ctx, filter, offset, limit);
    }

    @Override
    public List<Task> onInsertAll(ClientRequestContext ctx, List<Task> objs) throws Exception {
        Task.GUARD.onInsertAll(ctx, objs);
        return super.insertAll(ctx, objs);
    }

    @Override
    public void onUpdate(ClientRequestContext ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        Task.GUARD.onUpdate(ctx, fields, filter);
        super.update(ctx, fields, filter);
    }

    @Override
    public void onDelete(ClientRequestContext ctx, Filter filter) throws Exception {
        Task.GUARD.onDelete(ctx, filter);
        ctx.transaction(dsl -> {
            Condition cond = this.buildCondition((DSLContext)dsl, filter);
            Task obj = dsl.selectFrom(Tables.TASK).where(cond).fetchAnyInto(Task.class);
            if (obj == null) {
                return;
            }
            super.delete((DSLContext)dsl, cond);
            AttachmentUtils.delete(ctx, dsl, AttachmentObjectType.TASK, obj.getId());
        });
    }
}

