/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.controllers;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.TaxRateRecord;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.request.RequestException;
import de.inahware.edvj.sql.SQLDataController;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Table;

public class TaxRateController
extends SQLDataController<TaxRate, TaxRateRecord, ClientRequestContext> {
    @Override
    public DataModel<TaxRate> getModel() {
        return TaxRate.MODEL;
    }

    @Override
    public Table<TaxRateRecord> getTable() {
        return Tables.TAX_RATE;
    }

    @Override
    public List<TaxRate> onSelectAll(ClientRequestContext ctx, Filter filter, int offset, int limit) throws Exception {
        TaxRate.GUARD.onSelectAll(ctx, filter, offset, limit);
        return super.selectAll(ctx, filter, offset, limit);
    }

    @Override
    public List<TaxRate> onInsertAll(ClientRequestContext ctx, List<TaxRate> objs) throws Exception {
        TaxRate.GUARD.onInsertAll(ctx, objs);
        return ctx.transactionResult(dsl -> {
            List res = super.insertAll((DSLContext)dsl, objs);
            for (TaxRate taxRate : res) {
                if (taxRate.getPrevTaxRateId() == null) continue;
                TaxRate old = dsl.selectFrom(Tables.TAX_RATE).where(TaxRate.COL_ID.eq((DSLContext)dsl, taxRate.getPrevTaxRateId())).fetchAnyInto(TaxRate.class);
                if (old == null) {
                    throw new RequestException();
                }
                old.setEnabled(false);
                dsl.newRecord(Tables.TAX_RATE, old).update(Tables.TAX_RATE.ENABLED);
                dsl.update(Tables.ARTICLE).set(Article.COL_TAX_RATE_ID.set((DSLContext)dsl, taxRate.getId())).where(Article.COL_TAX_RATE_ID.eq((DSLContext)dsl, old.getId())).execute();
            }
            return res;
        });
    }

    @Override
    public void onUpdate(ClientRequestContext ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        TaxRate.GUARD.onUpdate(ctx, fields, filter);
        super.update(ctx, fields, filter);
    }

    @Override
    public void onDelete(ClientRequestContext ctx, Filter filter) throws Exception {
        TaxRate.GUARD.onDelete(ctx, filter);
        super.delete(ctx, filter);
    }
}

