/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.controllers;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.VendorRecord;
import de.inahware.dav.models.Counter;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.requests.AttachmentUtils;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.sql.SQLDataController;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Table;

public class VendorController
extends SQLDataController<Vendor, VendorRecord, ClientRequestContext> {
    @Override
    public DataModel<Vendor> getModel() {
        return Vendor.MODEL;
    }

    @Override
    public Table<VendorRecord> getTable() {
        return Tables.VENDOR;
    }

    @Override
    public List<Vendor> onSelectAll(ClientRequestContext ctx, Filter filter, int offset, int limit) throws Exception {
        Vendor.GUARD.onSelectAll(ctx, filter, offset, limit);
        return super.selectAll(ctx, filter, offset, limit);
    }

    @Override
    public List<Vendor> onInsertAll(ClientRequestContext ctx, List<Vendor> objs) throws Exception {
        Vendor.GUARD.onInsertAll(ctx, objs);
        return ctx.transactionResult(dsl -> {
            Counter counter = dsl.selectFrom(Tables.COUNTER).where(Tables.COUNTER.NAME.eq("Vendor")).forUpdate().fetchAnyInto(Counter.class);
            for (Vendor obj : objs) {
                String number = counter.generateNext();
                obj.setNumber(number);
            }
            dsl.newRecord(Tables.COUNTER, counter).update(Tables.COUNTER.LAST_PREFIX, Tables.COUNTER.COUNT);
            return super.insertAll(ctx, objs);
        });
    }

    @Override
    public void onUpdate(ClientRequestContext ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        Vendor.GUARD.onUpdate(ctx, fields, filter);
        super.update(ctx, fields, filter);
    }

    @Override
    public void onDelete(ClientRequestContext ctx, Filter filter) throws Exception {
        Vendor.GUARD.onDelete(ctx, filter);
        ctx.transaction(dsl -> {
            Condition cond = this.buildCondition((DSLContext)dsl, filter);
            Vendor obj = dsl.selectFrom(Tables.VENDOR).where(cond).fetchAnyInto(Vendor.class);
            if (obj == null) {
                return;
            }
            super.delete((DSLContext)dsl, cond);
            AttachmentUtils.delete(ctx, dsl, AttachmentObjectType.VENDOR, obj.getId());
        });
    }
}

