/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.types;

import java.util.ResourceBundle;

public enum DocumentType {
    OFFER,
    CONFIRM,
    RECEIPT,
    INVOICE,
    DEPOSITINVOICE,
    PARTIALPAYMENTINVOICE,
    FINALPAYMENTINVOICE,
    CANCELINVOICE,
    REQUEST,
    PURCHASE,
    PAYMENT,
    CANCEL;


    public String getLocalizedString(ResourceBundle bundle) {
        return bundle.getString("DocumentType." + this);
    }

    public boolean usesCustomer() {
        switch (this) {
            case OFFER: 
            case CONFIRM: 
            case RECEIPT: 
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: 
            case CANCELINVOICE: {
                return true;
            }
            case REQUEST: 
            case PURCHASE: 
            case PAYMENT: 
            case CANCEL: {
                return false;
            }
        }
        return false;
    }

    public boolean usesVendor() {
        return !this.usesCustomer();
    }

    public boolean needsServiceType() {
        switch (this) {
            case OFFER: 
            case CONFIRM: {
                return false;
            }
            case RECEIPT: 
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: 
            case CANCELINVOICE: {
                return true;
            }
            case REQUEST: 
            case PURCHASE: 
            case PAYMENT: 
            case CANCEL: {
                return false;
            }
        }
        return false;
    }

    public boolean needsShippingDate() {
        switch (this) {
            case OFFER: 
            case CONFIRM: {
                return false;
            }
            case RECEIPT: {
                return true;
            }
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: 
            case CANCELINVOICE: {
                return false;
            }
            case REQUEST: 
            case PURCHASE: 
            case PAYMENT: 
            case CANCEL: {
                return false;
            }
        }
        return false;
    }

    public boolean needsPrices() {
        switch (this) {
            case OFFER: {
                return false;
            }
            case CONFIRM: {
                return true;
            }
            case RECEIPT: {
                return false;
            }
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: 
            case CANCELINVOICE: {
                return true;
            }
            case REQUEST: {
                return false;
            }
            case PURCHASE: 
            case PAYMENT: 
            case CANCEL: {
                return true;
            }
        }
        return false;
    }

    public DocumentType getNumberType() {
        switch (this) {
            case OFFER: {
                return OFFER;
            }
            case CONFIRM: {
                return CONFIRM;
            }
            case RECEIPT: {
                return RECEIPT;
            }
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: {
                return INVOICE;
            }
            case CANCELINVOICE: {
                return CANCELINVOICE;
            }
            case REQUEST: {
                return REQUEST;
            }
            case PURCHASE: {
                return PURCHASE;
            }
            case PAYMENT: {
                return PAYMENT;
            }
            case CANCEL: {
                return CANCEL;
            }
        }
        return null;
    }

    public boolean isCancellableInvoice() {
        switch (this) {
            case OFFER: 
            case CONFIRM: 
            case RECEIPT: {
                return false;
            }
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: {
                return true;
            }
            case CANCELINVOICE: {
                return false;
            }
            case REQUEST: 
            case PURCHASE: 
            case PAYMENT: 
            case CANCEL: {
                return false;
            }
        }
        return false;
    }

    public boolean isPartialInvoice() {
        switch (this) {
            case OFFER: 
            case CONFIRM: 
            case RECEIPT: 
            case INVOICE: {
                return false;
            }
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: {
                return true;
            }
            case FINALPAYMENTINVOICE: 
            case CANCELINVOICE: {
                return false;
            }
            case REQUEST: 
            case PURCHASE: 
            case PAYMENT: 
            case CANCEL: {
                return false;
            }
        }
        return false;
    }

    public boolean isContinuedPartialInvoice() {
        switch (this) {
            case OFFER: 
            case CONFIRM: 
            case RECEIPT: 
            case INVOICE: 
            case DEPOSITINVOICE: {
                return false;
            }
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: {
                return true;
            }
            case CANCELINVOICE: {
                return false;
            }
            case REQUEST: 
            case PURCHASE: 
            case PAYMENT: 
            case CANCEL: {
                return false;
            }
        }
        return false;
    }

    public boolean isFinalInvoice() {
        switch (this) {
            case OFFER: 
            case CONFIRM: 
            case RECEIPT: {
                return false;
            }
            case INVOICE: {
                return true;
            }
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: {
                return false;
            }
            case FINALPAYMENTINVOICE: 
            case CANCELINVOICE: {
                return true;
            }
            case REQUEST: 
            case PURCHASE: 
            case PAYMENT: 
            case CANCEL: {
                return false;
            }
        }
        return false;
    }

    public boolean isPayable() {
        switch (this) {
            case OFFER: 
            case CONFIRM: 
            case RECEIPT: {
                return false;
            }
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: 
            case CANCELINVOICE: {
                return true;
            }
            case REQUEST: 
            case PURCHASE: {
                return false;
            }
            case PAYMENT: 
            case CANCEL: {
                return true;
            }
        }
        return false;
    }

    public boolean isCompletable() {
        switch (this) {
            case OFFER: 
            case CONFIRM: 
            case RECEIPT: 
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: 
            case CANCELINVOICE: {
                return false;
            }
            case REQUEST: {
                return false;
            }
            case PURCHASE: {
                return true;
            }
            case PAYMENT: 
            case CANCEL: {
                return false;
            }
        }
        return false;
    }

    public boolean isCancellable() {
        switch (this) {
            case OFFER: {
                return true;
            }
            case CONFIRM: {
                return false;
            }
            case RECEIPT: 
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: 
            case CANCELINVOICE: {
                return true;
            }
            case REQUEST: {
                return true;
            }
            case PURCHASE: {
                return false;
            }
            case PAYMENT: 
            case CANCEL: {
                return true;
            }
        }
        return false;
    }

    public boolean doesCancel() {
        switch (this) {
            case OFFER: 
            case CONFIRM: 
            case RECEIPT: 
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: {
                return false;
            }
            case CANCELINVOICE: {
                return true;
            }
            case REQUEST: 
            case PURCHASE: 
            case PAYMENT: {
                return false;
            }
            case CANCEL: {
                return true;
            }
        }
        return false;
    }

    public boolean generatesNotice() {
        switch (this) {
            case OFFER: 
            case CONFIRM: 
            case RECEIPT: {
                return false;
            }
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: {
                return true;
            }
            case CANCELINVOICE: {
                return false;
            }
            case REQUEST: 
            case PURCHASE: 
            case PAYMENT: 
            case CANCEL: {
                return false;
            }
        }
        return false;
    }

    public boolean generatesRecord() {
        switch (this) {
            case OFFER: 
            case CONFIRM: 
            case RECEIPT: {
                return false;
            }
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: 
            case CANCELINVOICE: {
                return true;
            }
            case REQUEST: 
            case PURCHASE: {
                return false;
            }
            case PAYMENT: 
            case CANCEL: {
                return true;
            }
        }
        return false;
    }

    public boolean getDisplayDueDate() {
        switch (this) {
            case OFFER: {
                return true;
            }
            case CONFIRM: 
            case RECEIPT: {
                return false;
            }
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: {
                return true;
            }
            case CANCELINVOICE: {
                return false;
            }
            case REQUEST: 
            case PURCHASE: 
            case PAYMENT: 
            case CANCEL: {
                return false;
            }
        }
        return false;
    }

    public boolean getDisplayPrices() {
        switch (this) {
            case OFFER: 
            case CONFIRM: {
                return true;
            }
            case RECEIPT: {
                return false;
            }
            case INVOICE: 
            case DEPOSITINVOICE: 
            case PARTIALPAYMENTINVOICE: 
            case FINALPAYMENTINVOICE: 
            case CANCELINVOICE: {
                return true;
            }
            case REQUEST: {
                return false;
            }
            case PURCHASE: 
            case PAYMENT: 
            case CANCEL: {
                return true;
            }
        }
        return false;
    }
}

