/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.types;

import de.inahware.dav.models.RecordCategory;
import de.inahware.dav.models.TaxRate;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class Report {
    private long unassigned;
    private BigDecimal netSum;
    private HashMap<Long, BigDecimal> net;
    private HashMap<Long, BigDecimal> taxSum;
    private HashMap<Long, HashMap<Long, BigDecimal>> taxes;
    private BigDecimal totalSum;
    private HashMap<Long, BigDecimal> total;

    private Report() {
    }

    public Report(long unassigned, Map<Long, BigDecimal> total) {
        this.unassigned = unassigned;
        this.netSum = null;
        this.net = null;
        this.taxSum = null;
        this.taxes = null;
        this.totalSum = total.get(null);
        this.total = new HashMap<Long, BigDecimal>(total);
        this.total.remove(null);
    }

    public Report(long unassigned, Map<Long, BigDecimal> net, Map<Long, Map<Long, BigDecimal>> taxes, Map<Long, BigDecimal> total) {
        this.unassigned = unassigned;
        this.netSum = net.get(null);
        this.net = new HashMap<Long, BigDecimal>(net);
        this.net.remove(null);
        this.taxSum = new HashMap<Long, BigDecimal>(taxes.get(null));
        this.taxes = new HashMap();
        for (Map.Entry<Long, Map<Long, BigDecimal>> entry : taxes.entrySet()) {
            this.taxes.put(entry.getKey(), new HashMap<Long, BigDecimal>(entry.getValue()));
        }
        this.taxes.remove(null);
        this.totalSum = total.get(null);
        this.total = new HashMap<Long, BigDecimal>(total);
        this.total.remove(null);
    }

    public long getUnassigned() {
        return this.unassigned;
    }

    public BigDecimal getNetSum() {
        return this.netSum;
    }

    public BigDecimal getNetOf(RecordCategory category) {
        return this.net.get(category.getId());
    }

    public BigDecimal getTaxSum(TaxRate taxRate) {
        return this.taxSum.get(taxRate.getId());
    }

    public BigDecimal getTaxOf(RecordCategory category, TaxRate taxRate) {
        return this.taxes.get(category.getId()).get(taxRate.getId());
    }

    public BigDecimal getTotalSum() {
        return this.totalSum;
    }

    public BigDecimal getTotalOf(RecordCategory category) {
        return this.total.get(category.getId());
    }
}

