/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models.types;

import de.inahware.dav.models.TaxRate;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TotalPrice {
    private boolean complete;
    private BigDecimal netSumBeforeDeductions;
    private BigDecimal netRestDeduction;
    private List<Long> taxRates;
    private Map<Long, BigDecimal> net;
    private Map<Long, BigDecimal> taxes;
    private Map<Long, BigDecimal> total;
    private BigDecimal netSum;
    private BigDecimal taxSum;
    private BigDecimal totalSum;

    private TotalPrice() {
    }

    public TotalPrice(boolean complete, BigDecimal sum) {
        this(complete, null, null, sum);
        this.netSumBeforeDeductions = this.netSum;
        this.netRestDeduction = BigDecimal.ZERO;
    }

    public TotalPrice(boolean complete, BigDecimal netSumBeforeDeductions, BigDecimal netRestDeduction, BigDecimal sum) {
        this.complete = complete;
        this.netSumBeforeDeductions = netSumBeforeDeductions;
        this.netRestDeduction = netRestDeduction;
        this.taxRates = List.of();
        this.net = new HashMap<Long, BigDecimal>();
        this.taxes = new HashMap<Long, BigDecimal>();
        this.total = new HashMap<Long, BigDecimal>();
        this.netSum = sum;
        this.taxSum = BigDecimal.ZERO;
        this.totalSum = sum;
    }

    public TotalPrice(boolean complete, List<TaxRate> taxRates, Map<Long, BigDecimal> net) {
        this(complete, null, null, taxRates, net);
        this.netSumBeforeDeductions = this.netSum;
        this.netRestDeduction = BigDecimal.ZERO;
    }

    public TotalPrice(boolean complete, BigDecimal netSumBeforeDeductions, BigDecimal netRestDeduction, List<TaxRate> taxRates, Map<Long, BigDecimal> net) {
        this.complete = complete;
        this.netSumBeforeDeductions = netSumBeforeDeductions;
        this.netRestDeduction = netRestDeduction;
        this.taxRates = new ArrayList<Long>(net.keySet());
        this.net = net;
        this.taxes = new HashMap<Long, BigDecimal>();
        this.total = new HashMap<Long, BigDecimal>();
        this.netSum = BigDecimal.ZERO;
        this.taxSum = BigDecimal.ZERO;
        this.totalSum = BigDecimal.ZERO;
        HashMap<Long, TaxRate> taxRatesById = new HashMap<Long, TaxRate>();
        for (TaxRate next : taxRates) {
            taxRatesById.put(next.getId(), next);
        }
        for (Long id : net.keySet()) {
            BigDecimal next_net = net.get(id);
            BigDecimal next_tax = next_net.multiply(((TaxRate)taxRatesById.get(id)).getRate().divide(new BigDecimal(100))).setScale(2, RoundingMode.HALF_UP);
            BigDecimal next_total = next_net.add(next_tax);
            this.taxes.put(id, next_tax);
            this.total.put(id, next_total);
            this.netSum = this.netSum.add(next_net);
            this.taxSum = this.taxSum.add(next_tax);
            this.totalSum = this.totalSum.add(next_total);
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public BigDecimal getNetSumBeforeDeductions() {
        return this.netSumBeforeDeductions;
    }

    public BigDecimal getNetRestDeduction() {
        return this.netRestDeduction;
    }

    public List<Long> getTaxRates() {
        return this.taxRates;
    }

    public Map<Long, BigDecimal> getNet() {
        return this.net;
    }

    public Map<Long, BigDecimal> getTaxes() {
        return this.taxes;
    }

    public Map<Long, BigDecimal> getTotal() {
        return this.total;
    }

    public BigDecimal getNetSum() {
        return this.netSum;
    }

    public BigDecimal getTaxSum() {
        return this.taxSum;
    }

    public BigDecimal getTotalSum() {
        return this.totalSum;
    }
}

