/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.request.RequestException;
import java.nio.file.Path;
import org.jooq.DSLContext;

public class AttachmentDownload
extends ClientRequest<Void> {
    private long id;

    private AttachmentDownload() {
    }

    public AttachmentDownload(long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public TypeReference<Void> getType() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void execute(ClientRequestContext ctx) throws Exception {
        return ctx.transactionResult(dsl -> {
            Attachment att = dsl.selectFrom(Tables.ATTACHMENT).where(Attachment.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(Attachment.class);
            if (att == null) {
                throw new RequestException();
            }
            Path path = ctx.getStoragePath().resolve(att.getPath());
            ctx.getSession().setDownloadFile(path);
            return null;
        });
    }
}

