/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.requests.ClientRequestContext;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import org.jooq.DSLContext;

public class AttachmentUtils {
    public static void incRef(DSLContext dsl, long id) throws Exception {
        Attachment att = dsl.selectFrom(Tables.ATTACHMENT).where(Attachment.COL_ID.eq(dsl, id)).fetchAnyInto(Attachment.class);
        if (att == null) {
            throw new RuntimeException();
        }
        AttachmentUtils.incRef(dsl, att);
    }

    public static void incRef(DSLContext dsl, Attachment att) throws Exception {
        AttachmentUtils.updateCounts(dsl, att, 1L, 0L);
    }

    public static void incLock(DSLContext dsl, long id) throws Exception {
        Attachment att = dsl.selectFrom(Tables.ATTACHMENT).where(Attachment.COL_ID.eq(dsl, id)).fetchAnyInto(Attachment.class);
        if (att == null) {
            throw new RuntimeException();
        }
        AttachmentUtils.incLock(dsl, att);
    }

    public static void incLock(DSLContext dsl, Attachment att) throws Exception {
        AttachmentUtils.updateCounts(dsl, att, 0L, 1L);
    }

    public static void incRefLock(DSLContext dsl, long id) throws Exception {
        Attachment att = dsl.selectFrom(Tables.ATTACHMENT).where(Attachment.COL_ID.eq(dsl, id)).fetchAnyInto(Attachment.class);
        if (att == null) {
            throw new RuntimeException();
        }
        AttachmentUtils.incRefLock(dsl, att);
    }

    public static void incRefLock(DSLContext dsl, Attachment att) throws Exception {
        AttachmentUtils.updateCounts(dsl, att, 1L, 1L);
    }

    public static void decRef(DSLContext dsl, long id) throws Exception {
        Attachment att = dsl.selectFrom(Tables.ATTACHMENT).where(Attachment.COL_ID.eq(dsl, id)).fetchAnyInto(Attachment.class);
        if (att == null) {
            throw new RuntimeException();
        }
        AttachmentUtils.decRef(dsl, att);
    }

    public static void decRef(DSLContext dsl, Attachment att) throws Exception {
        AttachmentUtils.updateCounts(dsl, att, -1L, 0L);
    }

    public static void decLock(DSLContext dsl, long id) throws Exception {
        Attachment att = dsl.selectFrom(Tables.ATTACHMENT).where(Attachment.COL_ID.eq(dsl, id)).fetchAnyInto(Attachment.class);
        if (att == null) {
            throw new RuntimeException();
        }
        AttachmentUtils.decLock(dsl, att);
    }

    public static void decLock(DSLContext dsl, Attachment att) throws Exception {
        AttachmentUtils.updateCounts(dsl, att, 0L, -1L);
    }

    public static void decRefLock(DSLContext dsl, long id) throws Exception {
        Attachment att = dsl.selectFrom(Tables.ATTACHMENT).where(Attachment.COL_ID.eq(dsl, id)).fetchAnyInto(Attachment.class);
        if (att == null) {
            throw new RuntimeException();
        }
        AttachmentUtils.decRefLock(dsl, att);
    }

    public static void decRefLock(DSLContext dsl, Attachment att) throws Exception {
        AttachmentUtils.updateCounts(dsl, att, -1L, -1L);
    }

    private static void updateCounts(DSLContext dsl, Attachment att, long ref, long lock) throws Exception {
        att.setRefCount(att.getRefCount() + ref);
        att.setLockCount(att.getLockCount() + lock);
        if (att.getRefCount() < 0L || att.getLockCount() < 0L || att.getLockCount() > att.getRefCount()) {
            throw new IllegalStateException();
        }
        dsl.newRecord(Tables.ATTACHMENT, att).update(Tables.ATTACHMENT.REF_COUNT, Tables.ATTACHMENT.LOCK_COUNT);
    }

    public static void delete(ClientRequestContext ctx, DSLContext dsl, AttachmentObjectType type, long id) throws Exception {
        Class<Attachment> atts = dsl.selectFrom(Tables.ATTACHMENT).where(Attachment.COL_OBJECT_TYPE.eq(dsl, AttachmentObjectType.ARTICLE)).and(Attachment.COL_OBJECT_ID.eq(dsl, id)).fetchInto(Attachment.class);
        Iterator iterator = atts.iterator();
        while (iterator.hasNext()) {
            Attachment att = (Attachment)iterator.next();
            AttachmentUtils.delete(ctx, dsl, att);
        }
    }

    public static void delete(ClientRequestContext ctx, DSLContext dsl, long id) throws Exception {
        Attachment att = dsl.selectFrom(Tables.ATTACHMENT).where(Attachment.COL_ID.eq(dsl, id)).fetchAnyInto(Attachment.class);
        if (att == null) {
            throw new RuntimeException();
        }
        AttachmentUtils.delete(ctx, dsl, att);
    }

    public static void delete(ClientRequestContext ctx, DSLContext dsl, Attachment att) throws Exception {
        dsl.deleteFrom(Tables.ATTACHMENT).where(Attachment.COL_ID.eq(dsl, att.getId())).execute();
        switch (att.getType()) {
            case TEXT: 
            case OTHER: {
                break;
            }
            case FILE: {
                Path path = ctx.getStoragePath().resolve(att.getPath());
                Files.delete(path);
            }
        }
    }
}

