/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import de.inahware.dav.DocumentRenderer;
import de.inahware.dav.Session;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Role;
import de.inahware.dav.models.User;
import de.inahware.edvj.VersionInfo;
import de.inahware.edvj.data.AttributeSet;
import de.inahware.edvj.query.QueryContext;
import de.inahware.edvj.request.PermissionContext;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.apache.commons.lang3.RandomStringUtils;
import org.jooq.DSLContext;
import org.jooq.TableLike;

public abstract class ClientRequestContext
implements QueryContext,
PermissionContext {
    private VersionInfo version;
    private ResourceBundle bundle;
    private Path storagePath;
    private DSLContext dsl;
    private Session session;

    public ClientRequestContext(VersionInfo version, ResourceBundle bundle, Path storagePath, DSLContext dsl, Session session) {
        this.version = version;
        this.bundle = bundle;
        this.storagePath = storagePath;
        this.dsl = dsl;
        this.session = session;
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public Path getStoragePath() {
        return this.storagePath;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public Session getSession() {
        return this.session;
    }

    public Session getOrCreateSession() throws Exception {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    public Session setSession(String token) throws Exception {
        this.session = this.createSession(token);
        return this.session;
    }

    public User getLogin() throws Exception {
        if (this.session == null || this.session.getLogin() == null) {
            return null;
        }
        return this.getDSLContext().selectFrom(Tables.USER).where(Tables.USER.ID.eq(this.session.getLogin())).fetchAnyInto(User.class);
    }

    public void setLogin(User login) throws Exception {
        this.session.setLogin(login == null ? null : login.getId());
    }

    @Override
    public DSLContext getDSLContext() {
        return this.dsl;
    }

    public AttributeSet getPermissions() throws Exception {
        DSLContext dsl = this.getDSLContext();
        User login = this.getLogin();
        if (login == null) {
            return new AttributeSet();
        }
        Class<Role> roles = dsl.select(Tables.ROLE.fields()).from((TableLike<?>)Tables.USER_ROLE).join(Tables.ROLE).on(Tables.USER_ROLE.ROLE_ID.eq(Tables.ROLE.ID)).where(Tables.USER_ROLE.USER_ID.eq(login.getId())).fetchInto(Role.class);
        AttributeSet permissions = new AttributeSet();
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            Role g = (Role)iterator.next();
            for (String path : g.getPermissions().getAllPaths()) {
                permissions.insert(path);
            }
        }
        return permissions;
    }

    @Override
    public boolean hasPermission(String name) throws Exception {
        return this.getPermissions().contains(name);
    }

    public Path tempFile() throws Exception {
        return this.tempFile(RandomStringUtils.randomAlphanumeric(32));
    }

    public Path tempFile(String suffix) throws Exception {
        if (this.session != null) {
            return this.storagePath.resolve("temp/" + this.session.getToken() + "-" + suffix);
        }
        return this.storagePath.resolve("temp/" + suffix);
    }

    public abstract Session createSession() throws Exception;

    public abstract Session createSession(String var1) throws Exception;

    public abstract DocumentRenderer createDocumentRenderer();
}

