/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.LineItem;
import de.inahware.dav.models.PendingNotice;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.requests.AttachmentUtils;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.dav.requests.DocumentUtils;
import de.inahware.edvj.request.RequestException;
import java.util.ArrayList;
import org.jooq.DSLContext;

public class DocumentCancel
extends ClientRequest<Void> {
    private long id;

    private DocumentCancel() {
    }

    public DocumentCancel(long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public TypeReference<Void> getType() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void execute(ClientRequestContext ctx) throws Exception {
        return ctx.transactionResult(dsl -> {
            DocumentFull document = dsl.selectFrom(Tables.DOCUMENT).where(DocumentFull.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(DocumentFull.class);
            if (document == null) {
                throw new RequestException();
            }
            if (document.getState() != OrderState.DRAFT) {
                if (!document.getType().isCancellable()) {
                    throw new RequestException();
                }
                if (document.getState() != OrderState.ONGOING) {
                    throw new RequestException();
                }
            }
            document.queryFullDocument((DSLContext)dsl);
            boolean delete = document.getState() == OrderState.DRAFT;
            document.setState(OrderState.CANCELED);
            dsl.newRecord(Tables.DOCUMENT, document).update(Tables.DOCUMENT.STATE);
            ArrayList<LineItem> items = new ArrayList<LineItem>();
            for (LineItem item : document.getItems()) {
                if ((item = new LineItem(item)).getState() == null) {
                    if (item.getNextLineItemId() != null) {
                        throw new RequestException();
                    }
                    item.setState(OrderState.CANCELED);
                    item.setPrevLineItemId(null);
                    item.setPrevDocumentId(null);
                }
                items.add(item);
            }
            DocumentUtils.updateItems(dsl, document, items);
            if (document.getType().generatesNotice()) {
                dsl.deleteFrom(Tables.PENDING_NOTICE).where(PendingNotice.COL_DOCUMENT_ID.eq((DSLContext)dsl, document.getId())).execute();
            }
            if (delete) {
                dsl.deleteFrom(Tables.DOCUMENT).where(Document.COL_ID.eq((DSLContext)dsl, document.getId())).execute();
                AttachmentUtils.delete(ctx, dsl, AttachmentObjectType.DOCUMENT, document.getId());
            }
            return null;
        });
    }
}

