/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.LineItem;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.dav.requests.DocumentUtils;
import de.inahware.edvj.request.RequestException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jooq.DSLContext;

public class DocumentCancelItems
extends ClientRequest<Void> {
    private long id;
    private ArrayList<Long> items;

    private DocumentCancelItems() {
    }

    public DocumentCancelItems(long id, List<Long> items) {
        this.id = id;
        this.items = new ArrayList<Long>(items);
    }

    @Override
    @JsonIgnore
    public TypeReference<Void> getType() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void execute(ClientRequestContext ctx) throws Exception {
        return ctx.transactionResult(dsl -> {
            DocumentFull document = dsl.selectFrom(Tables.DOCUMENT).where(DocumentFull.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(DocumentFull.class);
            if (document == null || document.getState() != OrderState.ONGOING) {
                throw new RequestException();
            }
            document.queryFullDocument((DSLContext)dsl);
            HashSet<Long> cancel = new HashSet<Long>(this.items);
            ArrayList<LineItem> items = new ArrayList<LineItem>();
            for (LineItem item : document.getItems()) {
                if (cancel.contains((item = new LineItem(item)).getId())) {
                    if (item.getState() != null) {
                        throw new RequestException();
                    }
                    if (item.getNextLineItemId() != null) {
                        throw new RequestException();
                    }
                    item.setState(OrderState.CANCELED);
                    item.setPrevLineItemId(null);
                    item.setPrevDocumentId(null);
                }
                items.add(item);
            }
            DocumentUtils.updateItems(dsl, document, items);
            return null;
        });
    }
}

