/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.LineItem;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.request.RequestException;
import java.util.Iterator;
import org.jooq.DSLContext;

public class DocumentComplete
extends ClientRequest<Void> {
    private long id;

    private DocumentComplete() {
    }

    public DocumentComplete(long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public TypeReference<Void> getType() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void execute(ClientRequestContext ctx) throws Exception {
        return ctx.transactionResult(dsl -> {
            Document order = dsl.selectFrom(Tables.DOCUMENT).where(Document.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(Document.class);
            if (order == null) {
                throw new RequestException();
            }
            if (!order.getType().isCompletable()) {
                throw new RequestException();
            }
            if (order.getState() != OrderState.ONGOING) {
                throw new RequestException();
            }
            Class<LineItem> entries = dsl.selectFrom(Tables.LINE_ITEM).where(Tables.LINE_ITEM.DOCUMENT_ID.eq(order.getId())).fetchInto(LineItem.class);
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                LineItem e = (LineItem)iterator.next();
                if (e.getState() != OrderState.ONGOING) continue;
                throw new RequestException();
            }
            order.setState(OrderState.COMPLETED);
            dsl.newRecord(Tables.DOCUMENT, order).update(Tables.DOCUMENT.STATE);
            return null;
        });
    }
}

