/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.DocumentRenderer;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.AttachmentRecord;
import de.inahware.dav.jooq.tables.records.RecordRecord;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.models.Counter;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.PendingNotice;
import de.inahware.dav.models.Person;
import de.inahware.dav.models.Record;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.AttachmentType;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.models.types.RecordTaxEntry;
import de.inahware.dav.models.types.TotalPrice;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.request.RequestException;
import java.math.BigDecimal;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.jooq.DSLContext;

public class DocumentFinishDraft
extends ClientRequest<Void> {
    private long id;

    private DocumentFinishDraft() {
    }

    public DocumentFinishDraft(long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public TypeReference<Void> getType() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void execute(ClientRequestContext ctx) throws Exception {
        ResourceBundle bundle = ctx.getBundle();
        String number = ctx.transactionResult(dsl -> {
            DocumentFull document = dsl.selectFrom(Tables.DOCUMENT).where(Document.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(DocumentFull.class);
            if (document == null || document.getState() != OrderState.DRAFT) {
                throw new RequestException();
            }
            Counter counter = dsl.selectFrom(Tables.COUNTER).where(Tables.COUNTER.NAME.eq("Document." + document.getType().getNumberType())).forUpdate().fetchAnyInto(Counter.class);
            String num = counter.generateNext();
            dsl.newRecord(Tables.COUNTER, counter).update(Tables.COUNTER.LAST_PREFIX, Tables.COUNTER.COUNT);
            return num;
        });
        return ctx.transactionResult(dsl -> {
            DocumentFull document = dsl.selectFrom(Tables.DOCUMENT).where(Document.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(DocumentFull.class);
            if (document == null || document.getState() != OrderState.DRAFT) {
                throw new RequestException();
            }
            document.queryFullDocument((DSLContext)dsl);
            if (document.getItems().isEmpty()) {
                throw new RequestException();
            }
            Class<TaxRate> taxRates = dsl.selectFrom(Tables.TAX_RATE).fetchInto(TaxRate.class);
            TotalPrice price = document.computeTotalPrice((List<TaxRate>)((Object)taxRates));
            document.setNumber(number);
            document.setState(OrderState.ONGOING);
            document.setTotalPrice(price.getTotalSum());
            if (document.getType().isPayable()) {
                document.setRemainingPrice(document.getTotalPrice());
            }
            DocumentRenderer renderer = ctx.createDocumentRenderer();
            Path temp = ctx.getStoragePath().resolve("temp");
            Files.createDirectories(temp, new FileAttribute[0]);
            String baseTitle = document.getType().getLocalizedString(bundle) + " " + document.getNumber();
            Object baseName = document.getType().getLocalizedString(bundle) + "_" + document.getNumber() + "-";
            baseName = !document.getCompany().isEmpty() ? (String)baseName + document.getCompany() : (String)baseName + Person.getDisplayName(ctx.getBundle(), document.getSalutation(), document.getPrefix(), document.getFirstName(), document.getLastName(), document.getCompany());
            baseName = ((String)baseName).replace(' ', '_');
            String tmpBase = ctx.getSession().getToken() + "-" + Instant.now().toEpochMilli();
            Path tmpPath = temp.resolve(tmpBase);
            PDDocument doc = renderer.renderDocument(document, false);
            doc.save(tmpPath.toFile());
            Attachment att = new Attachment(AttachmentObjectType.DOCUMENT, document.getId(), AttachmentType.FILE, "application/pdf");
            att.setTitle(baseTitle);
            att.setFilename((String)baseName + ".pdf");
            att.setFilesize(Files.size(tmpPath));
            att.setRefCount(1L);
            att.setLockCount(1L);
            AttachmentRecord rec = dsl.newRecord(Tables.ATTACHMENT, att);
            rec.insert();
            rec.into(att);
            Path path = ctx.getStoragePath().resolve(att.getPath());
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.move(tmpPath, path, new CopyOption[0]);
            document.setAttachmentId(att.getId());
            String tmpBase2 = ctx.getSession().getToken() + "-" + Instant.now().toEpochMilli();
            Path tmpPath2 = temp.resolve(tmpBase2);
            PDDocument doc2 = renderer.renderDocument(document, true);
            doc2.save(tmpPath2.toFile());
            Attachment att2 = new Attachment(AttachmentObjectType.DOCUMENT, document.getId(), AttachmentType.FILE, "application/pdf");
            att2.setTitle(baseTitle + " - headless");
            att2.setFilename((String)baseName + "-headless.pdf");
            att2.setFilesize(Files.size(tmpPath2));
            att2.setRefCount(1L);
            att2.setLockCount(1L);
            AttachmentRecord rec2 = dsl.newRecord(Tables.ATTACHMENT, att2);
            rec2.insert();
            rec2.into(att2);
            Path path2 = ctx.getStoragePath().resolve(att2.getPath());
            Files.createDirectories(path2.getParent(), new FileAttribute[0]);
            Files.move(tmpPath2, path2, new CopyOption[0]);
            document.setHeadlessAttachmentId(att2.getId());
            dsl.newRecord(Tables.DOCUMENT, document).update(Tables.DOCUMENT.NUMBER, Tables.DOCUMENT.STATE, Tables.DOCUMENT.TOTAL_PRICE, Tables.DOCUMENT.REMAINING_PRICE, Tables.DOCUMENT.ATTACHMENT_ID, Tables.DOCUMENT.HEADLESS_ATTACHMENT_ID);
            if (document.getType().generatesNotice() && document.getDueDate() != null) {
                PendingNotice notice = new PendingNotice();
                notice.setDocumentId(document.getId());
                notice.setDate(document.getDueDate());
                notice.setCount(1L);
                dsl.newRecord(Tables.PENDING_NOTICE, notice).insert();
            }
            if (document.getType().generatesRecord()) {
                Record record = new Record();
                record.setDate(document.getDate());
                record.setCategoryId(null);
                record.setNetAmount(price.getNetSum());
                record.setTotalAmount(price.getTotalSum());
                List<RecordTaxEntry> taxes = price.getTaxes().entrySet().stream().map(entry -> new RecordTaxEntry((Long)entry.getKey(), (BigDecimal)entry.getValue())).collect(Collectors.toList());
                record.setTaxEntries(taxes);
                record.setDescription("");
                record.setDocumentId(document.getId());
                record.setAttachmentId(null);
                RecordRecord rec3 = dsl.newRecord(Tables.RECORD, record);
                rec3.insert();
                rec3.into(record);
                Attachment recordAtt = new Attachment(AttachmentObjectType.RECORD, record.getId(), att.getType(), att.getSubtype(), true, att.getTitle());
                recordAtt.setRefCount(1L);
                recordAtt.setFilename(att.getFilename());
                recordAtt.setFilesize(att.getFilesize());
                AttachmentRecord rec4 = dsl.newRecord(Tables.ATTACHMENT, recordAtt);
                rec4.insert();
                rec4.into(recordAtt);
                Path path_att = ctx.getStoragePath().resolve(att.getPath());
                Path path_record_att = ctx.getStoragePath().resolve(recordAtt.getPath());
                Files.createDirectories(path_record_att.getParent(), new FileAttribute[0]);
                Files.copy(path_att, path_record_att, new CopyOption[0]);
                record.setAttachmentId(recordAtt.getId());
                dsl.newRecord(Tables.RECORD, record).update(Tables.RECORD.ATTACHMENT_ID);
            }
            return null;
        });
    }
}

