/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.LineItem;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.dav.requests.DocumentUtils;
import de.inahware.edvj.request.RequestException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.DSLContext;

public class DocumentMerge
extends ClientRequest<Void> {
    private long id;
    private ArrayList<Long> entries;

    private DocumentMerge() {
    }

    public DocumentMerge(long id, List<Long> entries) {
        this.id = id;
        this.entries = new ArrayList<Long>(entries);
    }

    @Override
    @JsonIgnore
    public TypeReference<Void> getType() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void execute(ClientRequestContext ctx) throws Exception {
        return ctx.transactionResult(dsl -> {
            DocumentFull order = dsl.selectFrom(Tables.DOCUMENT).where(Document.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(DocumentFull.class);
            if (order == null || !order.getType().isCompletable()) {
                throw new RequestException();
            }
            order.setItems((List<LineItem>)((Object)dsl.selectFrom(Tables.LINE_ITEM).where(Tables.LINE_ITEM.DOCUMENT_ID.eq(order.getId())).fetchInto(LineItem.class)));
            List<LineItem> entries2 = LineItem.mergeById(order.getItems(), this.entries);
            if (entries2 == null) {
                throw new RequestException();
            }
            DocumentUtils.updateItems(dsl, order, entries2);
            return null;
        });
    }
}

