/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.LineItem;
import de.inahware.dav.models.PendingNotice;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.request.RequestException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jooq.DSLContext;

public class DocumentPay
extends ClientRequest<DocumentFull> {
    private long id;
    private BigDecimal amount;

    private DocumentPay() {
    }

    public DocumentPay(long id, BigDecimal amount) {
        this.id = id;
        this.amount = amount;
    }

    @Override
    @JsonIgnore
    public TypeReference<DocumentFull> getType() {
        return new TypeReference<DocumentFull>(){};
    }

    @Override
    public DocumentFull execute(ClientRequestContext ctx) throws Exception {
        return ctx.transactionResult(dsl -> {
            if (this.amount.signum() < 0) {
                throw new RequestException();
            }
            DocumentFull document = dsl.selectFrom(Tables.DOCUMENT).where(Document.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(DocumentFull.class);
            if (document == null) {
                throw new RequestException();
            }
            if (!document.getType().isPayable()) {
                throw new RequestException();
            }
            if (document.getState() != OrderState.ONGOING) {
                throw new RequestException();
            }
            document.queryFullDocument((DSLContext)dsl);
            BigDecimal remaining = document.getRemainingPrice().subtract(this.amount).setScale(2, RoundingMode.UNNECESSARY);
            if (remaining.signum() < 0) {
                throw new RequestException();
            }
            if (remaining.signum() > 0) {
                document.setRemainingPrice(remaining);
                dsl.newRecord(Tables.DOCUMENT, document).update(Tables.DOCUMENT.REMAINING_PRICE);
            } else {
                document.setRemainingPrice(null);
                if (document.getType().isFinalInvoice()) {
                    for (LineItem item2 : document.getItems()) {
                        item2.setState(OrderState.COMPLETED);
                        dsl.newRecord(Tables.LINE_ITEM, item2).update(Tables.LINE_ITEM.STATE);
                    }
                    document.setState(OrderState.COMPLETED);
                } else {
                    boolean itemsCompleted = document.getItems().stream().allMatch(item -> item.getState() != null || item.getNextLineItemId() != null);
                    if (itemsCompleted) {
                        document.setState(OrderState.COMPLETED);
                    }
                }
                dsl.newRecord(Tables.DOCUMENT, document).update(Tables.DOCUMENT.STATE, Tables.DOCUMENT.REMAINING_PRICE);
                if (document.getType().generatesNotice()) {
                    dsl.deleteFrom(Tables.PENDING_NOTICE).where(PendingNotice.COL_DOCUMENT_ID.eq((DSLContext)dsl, document.getId())).execute();
                }
            }
            return document;
        });
    }
}

