/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.request.RequestException;
import org.jooq.DSLContext;

public class DocumentPrinted
extends ClientRequest<DocumentFull> {
    private long id;

    private DocumentPrinted() {
    }

    public DocumentPrinted(long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public TypeReference<DocumentFull> getType() {
        return new TypeReference<DocumentFull>(){};
    }

    @Override
    public DocumentFull execute(ClientRequestContext ctx) throws Exception {
        return ctx.transactionResult(dsl -> {
            DocumentFull document = dsl.selectFrom(Tables.DOCUMENT).where(Document.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(DocumentFull.class);
            if (document == null || document.getState() == OrderState.DRAFT) {
                throw new RequestException();
            }
            document.queryFullDocument((DSLContext)dsl);
            document.setPrinted(document.getPrinted() + 1L);
            dsl.newRecord(Tables.DOCUMENT, document).update(Tables.DOCUMENT.PRINTED);
            return document;
        });
    }
}

