/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.DeductionRecord;
import de.inahware.dav.jooq.tables.records.LineItemRecord;
import de.inahware.dav.models.Deduction;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.LineItem;
import de.inahware.dav.models.types.OrderState;
import de.inahware.edvj.request.RequestException;
import java.util.HashSet;
import java.util.List;
import org.jooq.DSLContext;

public class DocumentUtils {
    public static void updateItems(DSLContext dsl, DocumentFull document, List<LineItem> new_items) throws Exception {
        HashSet<Long> checkDocuments = new HashSet<Long>();
        if (document.getId() == null) {
            checkDocuments.add(document.getId());
        }
        for (LineItem item2 : document.getItems()) {
            if (item2.getPrevLineItemId() == null) continue;
            checkDocuments.add(item2.getPrevDocumentId());
            dsl.update(Tables.LINE_ITEM).set(LineItem.COL_NEXT_LINE_ITEM_ID.set(dsl, null)).set(LineItem.COL_NEXT_DOCUMENT_ID.set(dsl, null)).where(LineItem.COL_ID.eq(dsl, item2.getPrevLineItemId())).execute();
        }
        for (LineItem item2 : new_items) {
            if (item2.getDocumentId() == null) {
                item2.setDocumentId(document.getId());
            }
            LineItemRecord record = dsl.newRecord(Tables.LINE_ITEM, item2);
            if (item2.getId() == null) {
                record.insert();
            } else {
                record.update();
            }
            record.into(item2);
            if (item2.getPrevLineItemId() == null) continue;
            checkDocuments.add(item2.getPrevDocumentId());
            LineItem prev = dsl.selectFrom(Tables.LINE_ITEM).where(LineItem.COL_ID.eq(dsl, item2.getPrevLineItemId())).fetchAnyInto(LineItem.class);
            if (prev.getNextLineItemId() != null) {
                throw new RequestException();
            }
            prev.setNextLineItemId(item2.getId());
            prev.setNextDocumentId(document.getId());
            dsl.newRecord(Tables.LINE_ITEM, prev).update(Tables.LINE_ITEM.NEXT_LINE_ITEM_ID, Tables.LINE_ITEM.NEXT_DOCUMENT_ID);
        }
        HashSet<Long> delete = new HashSet<Long>();
        for (LineItem item3 : document.getItems()) {
            delete.add(item3.getId());
        }
        for (LineItem item3 : new_items) {
            delete.remove(item3.getId());
        }
        for (Long next : delete) {
            dsl.deleteFrom(Tables.LINE_ITEM).where(LineItem.COL_ID.eq(dsl, next)).execute();
        }
        for (Long id : checkDocuments) {
            DocumentFull document2 = dsl.selectFrom(Tables.DOCUMENT).where(DocumentFull.COL_ID.eq(dsl, id)).fetchAnyInto(DocumentFull.class);
            document2.queryFullDocument(dsl);
            boolean itemsCompleted = document2.getItems().stream().allMatch(item -> item.getState() != null || item.getNextLineItemId() != null);
            if (document2.getRemainingPrice() == null && itemsCompleted) {
                document2.setState(OrderState.COMPLETED);
            } else {
                document2.setState(OrderState.ONGOING);
            }
            dsl.newRecord(Tables.DOCUMENT, document2).update(Tables.DOCUMENT.STATE);
        }
    }

    public static void updateDeductions(DSLContext dsl, DocumentFull document, List<Deduction> new_deductions) throws Exception {
        for (Deduction deduction : new_deductions) {
            if (deduction.getDocumentId() == null) {
                deduction.setDocumentId(document.getId());
            }
            DeductionRecord record = dsl.newRecord(Tables.DEDUCTION, deduction);
            if (deduction.getId() == null) {
                record.insert();
            } else {
                record.update();
            }
            record.into(deduction);
        }
        HashSet<Long> delete = new HashSet<Long>();
        for (Deduction deduction : document.getDeductions()) {
            delete.add(deduction.getId());
        }
        for (Deduction deduction : new_deductions) {
            delete.remove(deduction.getId());
        }
        for (Long next : delete) {
            dsl.deleteFrom(Tables.DEDUCTION).where(Deduction.COL_ID.eq(dsl, next)).execute();
        }
    }
}

