/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.BankStatementItemRecord;
import de.inahware.dav.jooq.tables.records.RecordRecord;
import de.inahware.dav.models.BankStatementItem;
import de.inahware.dav.models.RecordCategory;
import de.inahware.dav.models.types.RecordTaxEntry;
import de.inahware.dav.models.types.Report;
import de.inahware.dav.models.types.ReportMethod;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Cursor;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.True;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.DSL;

public class GenerateReport
extends ClientRequest<Report> {
    private LocalDate from;
    private LocalDate until;
    private ReportMethod method;

    private GenerateReport() {
    }

    public GenerateReport(LocalDate from, LocalDate until, ReportMethod method) {
        this.from = from;
        this.until = until;
        this.method = method;
    }

    @Override
    @JsonIgnore
    public TypeReference<Report> getType() {
        return new TypeReference<Report>(){};
    }

    @Override
    public Report execute(ClientRequestContext ctx) throws Exception {
        return ctx.transactionResult(dsl -> {
            Class<RecordCategory> categories = dsl.selectFrom(Tables.RECORD_CATEGORY).fetchInto(RecordCategory.class);
            HashMap<Long, RecordCategory> categories_map = new HashMap<Long, RecordCategory>();
            Iterator iterator = categories.iterator();
            while (iterator.hasNext()) {
                RecordCategory c = (RecordCategory)iterator.next();
                categories_map.put(c.getId(), c);
            }
            switch (this.method) {
                case RECORD: {
                    long unassigned = 0L;
                    HashMap<Long, BigDecimal> net = new HashMap<Long, BigDecimal>();
                    HashMap<Long, Map<Long, BigDecimal>> taxes = new HashMap<Long, Map<Long, BigDecimal>>();
                    HashMap<Long, BigDecimal> total = new HashMap<Long, BigDecimal>();
                    net.put(null, BigDecimal.ZERO);
                    taxes.put(null, new HashMap());
                    total.put(null, BigDecimal.ZERO);
                    Iterator iterator2 = categories.iterator();
                    while (iterator2.hasNext()) {
                        RecordCategory c = (RecordCategory)iterator2.next();
                        net.put(c.getId(), BigDecimal.ZERO);
                        taxes.put(c.getId(), new HashMap());
                        total.put(c.getId(), BigDecimal.ZERO);
                    }
                    True c_from = this.from != null ? Tables.RECORD.DATE.ge(this.from) : DSL.trueCondition();
                    True c_until = this.until != null ? Tables.RECORD.DATE.le(this.until) : DSL.trueCondition();
                    try (Cursor cursor = dsl.selectFrom(Tables.RECORD).where((Condition)c_from).and(c_until).fetchLazy();){
                        block16: for (RecordRecord row : cursor) {
                            de.inahware.dav.models.Record record = (de.inahware.dav.models.Record)((Object)((AbstractRecord)row).into(de.inahware.dav.models.Record.class));
                            if (record.getCategoryId() == null) {
                                ++unassigned;
                                continue;
                            }
                            Long id = record.getCategoryId();
                            while (true) {
                                net.put(id, net.get(id).add(record.getNetAmount()));
                                total.put(id, total.get(id).add(record.getTotalAmount()));
                                Map<Long, BigDecimal> c_taxes = taxes.get(id);
                                for (RecordTaxEntry tax : record.getTaxEntries()) {
                                    c_taxes.put(tax.getTaxRateId(), c_taxes.getOrDefault(tax.getTaxRateId(), BigDecimal.ZERO).add(tax.getAmount()));
                                }
                                if (id == null) continue block16;
                                id = ((RecordCategory)categories_map.get(id)).getParentId();
                            }
                        }
                    }
                    return new Report(unassigned, net, taxes, total);
                }
                case BANK_STATEMENT: 
                case BANK_STATEMENT_VALUE: {
                    long unassigned = 0L;
                    HashMap<Long, BigDecimal> total = new HashMap<Long, BigDecimal>();
                    total.put(null, BigDecimal.ZERO);
                    Iterator taxes = categories.iterator();
                    while (taxes.hasNext()) {
                        RecordCategory c = (RecordCategory)taxes.next();
                        total.put(c.getId(), BigDecimal.ZERO);
                    }
                    TableField<BankStatementItemRecord, LocalDate> field = this.method == ReportMethod.BANK_STATEMENT ? Tables.BANK_STATEMENT_ITEM.DATE : Tables.BANK_STATEMENT_ITEM.VALUE_DATE;
                    True c_from = this.from != null ? field.ge(this.from) : DSL.trueCondition();
                    True c_until = this.until != null ? field.le(this.until) : DSL.trueCondition();
                    try (Cursor cursor = dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)Tables.BANK_STATEMENT_ITEM).leftOuterJoin(Tables.RECORD).on(Tables.BANK_STATEMENT_ITEM.RECORD_ID.eq(Tables.RECORD.ID)).where((Condition)c_from).and(c_until).fetchLazy();){
                        block20: for (Record row : cursor) {
                            BankStatementItem item = (BankStatementItem)((Object)((AbstractRecord)row.into(Tables.BANK_STATEMENT_ITEM)).into(BankStatementItem.class));
                            if (item.getRecordId() == null) {
                                ++unassigned;
                                continue;
                            }
                            de.inahware.dav.models.Record record = (de.inahware.dav.models.Record)((Object)((AbstractRecord)row.into(Tables.RECORD)).into(de.inahware.dav.models.Record.class));
                            if (record.getCategoryId() == null) {
                                ++unassigned;
                                continue;
                            }
                            Long id = record.getCategoryId();
                            while (true) {
                                total.put(id, total.get(id).add(item.getValue()));
                                if (id == null) continue block20;
                                id = ((RecordCategory)categories_map.get(id)).getParentId();
                            }
                        }
                    }
                    return new Report(unassigned, total);
                }
            }
            throw new RuntimeException("unreachable");
        });
    }
}

