/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.Hashing;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.UserAuthPasswordRecord;
import de.inahware.dav.models.User;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.dav.requests.LoginException;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Login
extends ClientRequest<User> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Login.class.getName());
    private String username;
    private char[] password;

    private Login() {
    }

    public Login(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    @Override
    @JsonIgnore
    public TypeReference<User> getType() {
        return new TypeReference<User>(){};
    }

    @Override
    public User execute(ClientRequestContext ctx) throws Exception {
        try {
            return ctx.transactionResult(dsl -> {
                User user;
                if (this.username == null && this.password == null) {
                    LOGGER.info("single-user login request");
                    Class<User> users = dsl.selectFrom(Tables.USER).limit(2).fetchInto(User.class);
                    if (users.size() != 1) {
                        throw new LoginException();
                    }
                    user = (User)users.get(0);
                    UserAuthPasswordRecord auth = (UserAuthPasswordRecord)dsl.selectFrom(Tables.USER_AUTH_PASSWORD).where(Tables.USER_AUTH_PASSWORD.USER_ID.eq(user.getId())).fetchAny();
                    if (auth != null) {
                        throw new LoginException();
                    }
                } else {
                    LOGGER.info("login request: " + this.username);
                    user = dsl.selectFrom(Tables.USER).where(User.COL_USERNAME.eq((DSLContext)dsl, this.username)).fetchAnyInto(User.class);
                    if (user == null) {
                        throw new LoginException();
                    }
                    UserAuthPasswordRecord auth = (UserAuthPasswordRecord)dsl.selectFrom(Tables.USER_AUTH_PASSWORD).where(Tables.USER_AUTH_PASSWORD.USER_ID.eq(user.getId())).fetchAny();
                    if (auth == null) {
                        throw new LoginException();
                    }
                    if (!Hashing.verifyPasswordHashEntry(auth.getPasswordAlgorithm(), auth.getPasswordHash(), this.password)) {
                        throw new LoginException();
                    }
                }
                ctx.setLogin(user);
                LOGGER.info("logged in as " + user.getUsername() + " (" + user.getId() + "; " + user.getName() + ")");
                return user;
            });
        }
        catch (Exception ex) {
            LOGGER.info("login failed");
            throw ex;
        }
    }
}

