/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Notice;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.requests.AttachmentUtils;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.request.RequestException;
import org.jooq.DSLContext;

public class NoticeCancel
extends ClientRequest<Notice> {
    private long id;

    private NoticeCancel() {
    }

    public NoticeCancel(long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public TypeReference<Notice> getType() {
        return new TypeReference<Notice>(){};
    }

    @Override
    public Notice execute(ClientRequestContext ctx) throws Exception {
        return ctx.transactionResult(dsl -> {
            Notice notice = dsl.selectFrom(Tables.NOTICE).where(Notice.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(Notice.class);
            if (notice == null) {
                throw new RequestException();
            }
            if (notice.getState() != OrderState.DRAFT && notice.getState() != OrderState.ONGOING) {
                throw new RequestException();
            }
            boolean delete = notice.getState() == OrderState.DRAFT;
            notice.setState(OrderState.CANCELED);
            dsl.newRecord(Tables.NOTICE, notice).update(Tables.NOTICE.STATE);
            if (delete) {
                dsl.deleteFrom(Tables.NOTICE).where(Notice.COL_ID.eq((DSLContext)dsl, notice.getId())).execute();
                AttachmentUtils.delete(ctx, dsl, AttachmentObjectType.NOTICE, notice.getId());
                return null;
            }
            return notice;
        });
    }
}

