/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.DocumentRenderer;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.AttachmentRecord;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.models.Notice;
import de.inahware.dav.models.PendingNotice;
import de.inahware.dav.models.Person;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.AttachmentType;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.request.RequestException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ResourceBundle;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.jooq.DSLContext;

public class NoticeFinishDraft
extends ClientRequest<Notice> {
    private long id;

    private NoticeFinishDraft() {
    }

    public NoticeFinishDraft(long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public TypeReference<Notice> getType() {
        return new TypeReference<Notice>(){};
    }

    @Override
    public Notice execute(ClientRequestContext ctx) throws Exception {
        ResourceBundle bundle = ctx.getBundle();
        return ctx.transactionResult(dsl -> {
            Notice notice = dsl.selectFrom(Tables.NOTICE).where(Notice.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(Notice.class);
            if (notice == null || notice.getState() != OrderState.DRAFT) {
                throw new RequestException();
            }
            notice.setState(OrderState.ONGOING);
            DocumentRenderer renderer = ctx.createDocumentRenderer();
            Path temp = ctx.getStoragePath().resolve("temp");
            Files.createDirectories(temp, new FileAttribute[0]);
            String baseTitle = bundle.getString("Notice") + " " + notice.getDocumentNumber();
            Object baseName = bundle.getString("Notice") + "_" + notice.getDocumentNumber() + "-";
            baseName = !notice.getCompany().isEmpty() ? (String)baseName + notice.getCompany() : (String)baseName + Person.getDisplayName(ctx.getBundle(), notice.getSalutation(), notice.getPrefix(), notice.getFirstName(), notice.getLastName(), notice.getCompany());
            baseName = ((String)baseName).replace(' ', '_');
            String tmpBase = ctx.getSession().getToken() + "-" + Instant.now().toEpochMilli();
            Path tmpPath = temp.resolve(tmpBase);
            PDDocument doc = renderer.renderNotice(notice, false);
            doc.save(tmpPath.toFile());
            Attachment att = new Attachment(AttachmentObjectType.NOTICE, notice.getId(), AttachmentType.FILE, "application/pdf");
            att.setTitle(baseTitle);
            att.setFilename((String)baseName + ".pdf");
            att.setFilesize(Files.size(tmpPath));
            att.setRefCount(1L);
            att.setLockCount(1L);
            AttachmentRecord rec = dsl.newRecord(Tables.ATTACHMENT, att);
            rec.insert();
            rec.into(att);
            Path path = ctx.getStoragePath().resolve(att.getPath());
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.move(tmpPath, path, new CopyOption[0]);
            notice.setAttachmentId(att.getId());
            String tmpBase2 = ctx.getSession().getToken() + "-" + Instant.now().toEpochMilli();
            Path tmpPath2 = temp.resolve(tmpBase2);
            PDDocument doc2 = renderer.renderNotice(notice, true);
            doc2.save(tmpPath2.toFile());
            Attachment att2 = new Attachment(AttachmentObjectType.NOTICE, notice.getId(), AttachmentType.FILE, "application/pdf");
            att2.setTitle(baseTitle + " - headless");
            att2.setFilename((String)baseName + "-headless.pdf");
            att2.setFilesize(Files.size(tmpPath2));
            att2.setRefCount(1L);
            att2.setLockCount(1L);
            AttachmentRecord rec2 = dsl.newRecord(Tables.ATTACHMENT, att2);
            rec2.insert();
            rec2.into(att2);
            Path path2 = ctx.getStoragePath().resolve(att2.getPath());
            Files.createDirectories(path2.getParent(), new FileAttribute[0]);
            Files.move(tmpPath2, path2, new CopyOption[0]);
            notice.setHeadlessAttachmentId(att2.getId());
            dsl.newRecord(Tables.NOTICE, notice).update(Tables.NOTICE.STATE, Tables.DOCUMENT.ATTACHMENT_ID, Tables.DOCUMENT.HEADLESS_ATTACHMENT_ID);
            if (notice.getDocumentId() != null) {
                PendingNotice notice2 = new PendingNotice();
                notice2.setDocumentId(notice.getDocumentId());
                notice2.setDate(notice.getPaymentDate());
                notice2.setCount(notice.getCount() + 1L);
                dsl.newRecord(Tables.PENDING_NOTICE, notice2).insert();
            }
            return notice;
        });
    }
}

