/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.PendingNotice;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.request.RequestException;
import java.time.LocalDate;
import org.jooq.DSLContext;

public class PendingNoticePostpone
extends ClientRequest<PendingNotice> {
    private long id;
    private LocalDate date;

    private PendingNoticePostpone() {
    }

    public PendingNoticePostpone(long id, LocalDate date) {
        this.id = id;
        this.date = date;
    }

    @Override
    @JsonIgnore
    public TypeReference<PendingNotice> getType() {
        return new TypeReference<PendingNotice>(){};
    }

    @Override
    public PendingNotice execute(ClientRequestContext ctx) throws Exception {
        return ctx.transactionResult(dsl -> {
            PendingNotice notice = dsl.selectFrom(Tables.PENDING_NOTICE).where(PendingNotice.COL_ID.eq((DSLContext)dsl, this.id)).fetchAnyInto(PendingNotice.class);
            if (notice == null) {
                throw new RequestException();
            }
            if (this.date.isBefore(notice.getDate())) {
                throw new RequestException("PendingNotice.errors.postpone_date_before_noticeDate");
            }
            notice.setDate(this.date);
            dsl.newRecord(Tables.PENDING_NOTICE, notice).update(Tables.PENDING_NOTICE.DATE);
            return notice;
        });
    }
}

