/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.Hashing;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.UserAuthPasswordRecord;
import de.inahware.dav.jooq.tables.records.UserRecord;
import de.inahware.dav.models.User;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.request.RequestException;
import org.jooq.DSLContext;

public class UserSetPassword
extends ClientRequest<Void> {
    private long id;
    private char[] password;

    private UserSetPassword() {
    }

    public UserSetPassword(long id, char[] password) {
        this.id = id;
        this.password = password;
    }

    @Override
    @JsonIgnore
    public TypeReference<Void> getType() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void execute(ClientRequestContext ctx) throws Exception {
        return ctx.transactionResult(dsl -> {
            UserRecord user = (UserRecord)dsl.selectFrom(Tables.USER).where(User.COL_ID.eq((DSLContext)dsl, this.id)).fetchAny();
            if (user == null) {
                throw new RequestException();
            }
            dsl.deleteFrom(Tables.USER_AUTH_PASSWORD).where(Tables.USER_AUTH_PASSWORD.USER_ID.eq(this.id)).execute();
            if (this.password == null) {
                return null;
            }
            String algorithm = Hashing.getDefault();
            byte[] hash = Hashing.generatePasswordHashEntry(algorithm, this.password);
            UserAuthPasswordRecord auth = dsl.newRecord(Tables.USER_AUTH_PASSWORD);
            auth.setUserId(this.id);
            auth.setPasswordAlgorithm(algorithm);
            auth.setPasswordHash(hash);
            auth.insert();
            return null;
        });
    }
}

