/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj;

import de.inahware.edvj.CombinedBundle;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class I18N {
    private static List<String> bundle_names = new ArrayList<String>();
    private static DateTimeFormatter fmt_date;
    private static DateTimeFormatter fmt_date_y;
    private static DateTimeFormatter fmt_date_ym;
    private static DateTimeFormatter fmt_datetime;
    private static DecimalFormat fmt_decimal;

    public static void addBundle(String name) {
        bundle_names.add(name);
    }

    public static ResourceBundle getBundle() {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>(bundle_names.stream().map(name -> ResourceBundle.getBundle(name)).collect(Collectors.toList()));
        Collections.reverse(bundles);
        return new CombinedBundle(bundles);
    }

    public static void setDateFormat(DateTimeFormatter fmt_date) {
        I18N.fmt_date = fmt_date;
    }

    public static void setDateFormat(String pattern) {
        I18N.setDateFormat(new DateTimeFormatterBuilder().appendPattern(pattern).toFormatter());
    }

    public static DateTimeFormatter getDateFormat() {
        return fmt_date;
    }

    public static String formatDate(LocalDate date) {
        return fmt_date.format(date);
    }

    public static String formatDate(LocalDate date, String empty) {
        return date == null ? empty : fmt_date.format(date);
    }

    public static LocalDate parseDate(String str) throws DateTimeParseException {
        return LocalDate.from(fmt_date.parse(str));
    }

    public static LocalDate tryParseDate(String str) {
        try {
            return I18N.parseDate(str);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    public static void setYearFormat(DateTimeFormatter fmt_date_y) {
        I18N.fmt_date_y = fmt_date_y;
    }

    public static void setYearFormat(String pattern) {
        I18N.setYearFormat(new DateTimeFormatterBuilder().appendPattern(pattern).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).toFormatter());
    }

    public static DateTimeFormatter getYearFormat() {
        return fmt_date_y;
    }

    public static String formatYear(LocalDate date) {
        return fmt_date_y.format(date);
    }

    public static String formatYear(LocalDate date, String empty) {
        return date == null ? empty : fmt_date_y.format(date);
    }

    public static LocalDate parseYear(String str) throws DateTimeParseException {
        return LocalDate.from(fmt_date_y.parse(str));
    }

    public static LocalDate tryParseYear(String str) {
        try {
            return I18N.parseYear(str);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    public static void setYearMonthFormat(DateTimeFormatter fmt_date_ym) {
        I18N.fmt_date_ym = fmt_date_ym;
    }

    public static void setYearMonthFormat(String pattern) {
        I18N.setYearMonthFormat(new DateTimeFormatterBuilder().appendPattern(pattern).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).toFormatter());
    }

    public static DateTimeFormatter getYearMonthFormat() {
        return fmt_date_ym;
    }

    public static String formatYearMonth(LocalDate date) {
        return fmt_date_ym.format(date);
    }

    public static String formatYearMonth(LocalDate date, String empty) {
        return date == null ? empty : fmt_date_ym.format(date);
    }

    public static LocalDate parseYearMonth(String str) throws DateTimeParseException {
        return LocalDate.from(fmt_date_ym.parse(str));
    }

    public static LocalDate tryParseYearMonth(String str) {
        try {
            return I18N.parseYearMonth(str);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    public static void setDateTimeFormat(DateTimeFormatter fmt_datetime) {
        I18N.fmt_datetime = fmt_datetime;
    }

    public static void setDateTimeFormat(String pattern) {
        I18N.setDateTimeFormat(new DateTimeFormatterBuilder().appendPattern(pattern).toFormatter());
    }

    public static DateTimeFormatter getDateTimeFormat() {
        return fmt_datetime;
    }

    public static String formatDateTime(LocalDateTime date) {
        return fmt_datetime.format(date);
    }

    public static String formatDateTime(LocalDateTime date, String empty) {
        return date == null ? empty : fmt_datetime.format(date);
    }

    public static LocalDateTime parseDateTime(String str) throws DateTimeParseException {
        return LocalDateTime.from(fmt_datetime.parse(str));
    }

    public static LocalDateTime tryParseDateTime(String str) {
        try {
            return I18N.parseDateTime(str);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    public static void setDecimalFormat(DecimalFormat fmt_decimal) {
        fmt_decimal.setParseBigDecimal(true);
        I18N.fmt_decimal = fmt_decimal;
    }

    public static DecimalFormat getDecimalFormat() {
        return fmt_decimal;
    }

    public static String formatDecimal(BigDecimal dec) {
        return fmt_decimal.format(dec);
    }

    public static String formatDecimal(BigDecimal dec, String empty) {
        return dec == null ? empty : fmt_decimal.format(dec);
    }

    public static BigDecimal parseDecimal(String str) throws ParseException {
        return (BigDecimal)fmt_decimal.parse(str);
    }

    public static BigDecimal tryParseDecimal(String str) {
        try {
            return (BigDecimal)fmt_decimal.parse(str);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    static {
        bundle_names.add("de.inahware.edvj.messages");
        I18N.setDateFormat("yyyy-MM-dd");
        I18N.setYearFormat("yyyy");
        I18N.setYearMonthFormat("yyyy-MM");
        I18N.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
        I18N.setDecimalFormat(new DecimalFormat());
    }
}

