/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Utils {
    public static final String[] BYTES_UNITS = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB"};

    public static <T> List<T> diff(List<T> list_old, List<T> list_new) {
        if (list_old.size() != list_new.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<T> res = new ArrayList<T>();
        for (int i = 0; i < list_old.size(); ++i) {
            T item_new;
            T item_old = list_old.get(i);
            if (item_old.equals(item_new = list_new.get(i))) continue;
            res.add(item_new);
        }
        return res;
    }

    public static Properties readConfig(Path path) throws IOException {
        Properties config = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            config.load(reader);
        }
        return config;
    }

    public static void writeConfig(Properties config, Path path, String name) throws IOException {
        try (OutputStream output = Files.newOutputStream(path, new OpenOption[0]);){
            config.store(output, name);
        }
    }

    public static String formatBytes(long size) {
        if (size < 1024L) {
            return size + BYTES_UNITS[0];
        }
        int i = 1;
        while (size >= 0x100000L) {
            ++i;
            size /= 1024L;
        }
        return String.format("%d.%03d %s", size / 1024L, size % 1024L * 1000L / 1024L, BYTES_UNITS[i]);
    }
}

