/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AttributeSet {
    private String name;
    private boolean marked;
    private boolean wildcard;
    private HashMap<String, AttributeSet> children;

    public AttributeSet() {
        this((String)null);
    }

    public AttributeSet(AttributeSet set) {
        this(set.name);
        this.marked = set.marked;
        this.wildcard = set.wildcard;
        for (String key : set.children.keySet()) {
            this.children.put(key, new AttributeSet(set.children.get(key)));
        }
    }

    private AttributeSet(String name) {
        this.name = name;
        this.marked = false;
        this.wildcard = false;
        this.children = new HashMap();
    }

    public boolean contains(String path) {
        return this.contains(path.isEmpty() ? new String[]{} : path.split("\\."), 0);
    }

    private boolean contains(String[] path, int offset) {
        if (offset == path.length) {
            return this.marked;
        }
        if (this.wildcard) {
            return true;
        }
        String next = path[offset];
        if (this.children.containsKey(next)) {
            return this.children.get(next).contains(path, offset + 1);
        }
        return false;
    }

    public void insert(String path) {
        this.insert(path.isEmpty() ? new String[]{} : path.split("\\."), 0);
    }

    private void insert(String[] path, int offset) {
        if (offset == path.length) {
            this.marked = true;
        } else {
            String next = path[offset];
            if (next.equals("*")) {
                this.wildcard = true;
            } else {
                if (!this.children.containsKey(next)) {
                    this.children.put(next, new AttributeSet());
                }
                this.children.get(next).insert(path, offset + 1);
            }
        }
    }

    public List<String> getAllPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        this.appendAllPaths(paths, "");
        return paths;
    }

    private void appendAllPaths(List<String> paths, String prefix) {
        Object prefix2;
        if (this.marked) {
            paths.add(prefix);
        }
        Object object = prefix2 = prefix.isEmpty() ? "" : prefix + ".";
        if (this.wildcard) {
            paths.add((String)prefix2 + "*");
        }
        List childs = this.children.keySet().stream().sorted().collect(Collectors.toList());
        for (String next : childs) {
            this.children.get(next).appendAllPaths(paths, (String)prefix2 + next);
        }
    }

    public String toString() {
        return this.getAllPaths().stream().collect(Collectors.joining("\n"));
    }

    public static AttributeSet fromString(String str) {
        AttributeSet res = new AttributeSet();
        str.lines().forEach(s -> res.insert((String)s));
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AttributeSet) {
            AttributeSet rhs = (AttributeSet)obj;
            if (!Objects.equals(this.name, rhs.name)) {
                return false;
            }
            if (this.wildcard != rhs.wildcard) {
                return false;
            }
            if (this.marked != rhs.marked) {
                return false;
            }
            return this.children.equals(rhs.children);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.wildcard, this.marked, this.children);
    }
}

