/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.data;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import java.util.Collection;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record1;

public abstract class DataColumn<T> {
    private Class<T> clazz;
    private String name;
    private boolean primary;

    public DataColumn(Class<T> clazz, String name, ColumnFlag ... flags) {
        this.clazz = clazz;
        this.name = name;
        this.primary = false;
        for (ColumnFlag flag : flags) {
            switch (flag) {
                case PRIMARY: {
                    this.primary = true;
                }
            }
        }
    }

    public Class<T> getValueClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public DataField<T> with(T value) {
        return new DataField<T>(this, value);
    }

    public String getLocalizedString(DataModel<?> model, ResourceBundle bundle) {
        return bundle.getString(model.getLocalizationScope() + "." + this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataColumn other = (DataColumn)obj;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getField(), other.getField());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getField());
    }

    public T deserialize(ObjectMapper mapper, JsonNode value) throws Exception {
        return mapper.treeToValue((TreeNode)value, this.clazz);
    }

    public Field<?> getField() {
        return null;
    }

    public DataField<T> fromRecord(Record record) {
        throw new UnsupportedOperationException();
    }

    public Condition eq(DSLContext dsl, T value) {
        throw new UnsupportedOperationException();
    }

    public Condition in(DSLContext dsl, Collection<T> values) {
        throw new UnsupportedOperationException();
    }

    public Record1<?> set(DSLContext dsl, T value) {
        throw new UnsupportedOperationException();
    }
}

