/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.SerializedDataField;
import de.inahware.edvj.query.filter.Filter;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;

public class DataField<T>
implements Filter {
    private DataColumn<T> column;
    private T value;

    public DataField(DataColumn<T> column, T value) {
        this.column = column;
        this.value = value;
    }

    public DataColumn<T> getColumn() {
        return this.column;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public SerializedDataField serialize(ObjectMapper mapper) {
        Object value = mapper.valueToTree(this.value);
        return new SerializedDataField(this.column.getName(), (JsonNode)value);
    }

    @Override
    public Condition buildCondition(DSLContext dsl) {
        return this.column.eq(dsl, this.value);
    }

    @Override
    public void getUniqueColumns(Set<DataColumn<?>> set) {
        set.add(this.column);
    }
}

