/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.SerializedFilter;
import de.inahware.edvj.request.RequestException;

public class SerializedDataField
extends SerializedFilter {
    private String column;
    private JsonNode value;

    private SerializedDataField() {
    }

    SerializedDataField(String column, JsonNode value) {
        this.column = column;
        this.value = value;
    }

    @Override
    public DataField<?> deserialize(ObjectMapper mapper, DataModel<?> model) throws Exception {
        DataColumn<?> column = model.getColumn(this.column);
        if (column == null) {
            throw new RequestException();
        }
        return this.deserializeImpl(mapper, column);
    }

    public <T> DataField<T> deserializeImpl(ObjectMapper mapper, DataColumn<T> column) throws Exception {
        T value = column.deserialize(mapper, this.value);
        return new DataField<T>(column, value);
    }
}

