/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.data.model;

import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DataModel<T extends DataObject> {
    private Class<T> clazz;
    private String name;
    private String localizationScope;
    private List<DataColumn<?>> columns;
    private List<DataColumn<?>> primaryColumns;
    private Map<DataColumn<?>, Function<T, ?>> getters;
    private Map<DataColumn<?>, BiConsumer<T, ?>> setters;
    private Map<String, DataColumn<?>> columnMap;

    public DataModel(Class<T> clazz) {
        this(clazz, clazz.getSimpleName());
    }

    public DataModel(Class<T> clazz, String name) {
        this(clazz, name, name);
    }

    public DataModel(Class<T> clazz, String name, String localizationScope) {
        this.clazz = clazz;
        this.name = name;
        this.localizationScope = localizationScope;
        this.columns = new ArrayList();
        this.primaryColumns = new ArrayList();
        this.columnMap = new HashMap();
        this.getters = new HashMap();
        this.setters = new HashMap();
    }

    public <U> DataModel<T> with(DataColumn<U> column, Function<T, U> getter, BiConsumer<T, U> setter) {
        this.columns.add(column);
        if (column.isPrimary()) {
            this.primaryColumns.add(column);
        }
        this.getters.put(column, getter);
        this.setters.put(column, setter);
        this.columnMap.put(column.getName(), column);
        return this;
    }

    public Class<T> getObjectClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizationScope() {
        return this.localizationScope;
    }

    public String getLocalizedString(ResourceBundle bundle) {
        return bundle.getString(this.getLocalizationScope());
    }

    public String getLocalizedString(DataColumn<?> col, ResourceBundle bundle) {
        return col.getLocalizedString(this, bundle);
    }

    public T createDefault() {
        try {
            return (T)((DataObject)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public T createFromFields(List<DataField<?>> fields) {
        T obj = this.createDefault();
        ((DataObject)obj).update(fields);
        return obj;
    }

    public List<DataColumn<?>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public List<DataColumn<?>> getPrimaryIndex() {
        return Collections.unmodifiableList(this.primaryColumns);
    }

    public DataColumn<?> getColumn(String name) {
        return this.columnMap.get(name);
    }

    <U> U get(DataObject obj, DataColumn<U> col) {
        return this.getSafe(obj, col);
    }

    <U> U getSafe(T obj, DataColumn<U> col) {
        return (U)this.getters.get(col).apply(obj);
    }

    <U> void set(DataObject obj, DataField<U> field) {
        this.setSafe(obj, field);
    }

    <U> void setSafe(T obj, DataField<U> field) {
        this.setSafe(obj, field.getColumn(), field.getValue());
    }

    <U> void set(DataObject obj, DataColumn<U> col, U value) {
        this.setSafe(obj, col, value);
    }

    <U> void setSafe(T obj, DataColumn<U> col, U value) {
        this.setters.get(col).accept(obj, value);
    }

    <U> DataField<U> getField(DataObject obj, DataColumn<U> col) {
        return this.getFieldSafe(obj, col);
    }

    <U> DataField<U> getFieldSafe(T obj, DataColumn<U> col) {
        return new DataField<U>(col, this.getSafe(obj, col));
    }

    void copyFrom(DataObject obj1, DataObject obj2) {
        this.copyFromSafe(obj1, obj2);
    }

    void copyFromSafe(T obj1, T obj2) {
        for (DataColumn<?> col : this.columns) {
            this.setSafe(obj1, this.getFieldSafe(obj2, col));
        }
    }

    List<DataField<?>> getFields(DataObject obj) {
        DataObject t = obj;
        return this.columns.stream().map(c -> this.getFieldSafe((T)t, (DataColumn)c)).collect(Collectors.toList());
    }

    List<DataField<?>> getPrimaryFields(DataObject obj) {
        DataObject t = obj;
        return this.primaryColumns.stream().map(c -> this.getFieldSafe((T)t, (DataColumn)c)).collect(Collectors.toList());
    }

    List<DataField<?>> diff(DataObject obj1, DataObject obj2) {
        return this.diffSafe(obj1, obj2);
    }

    List<DataField<?>> diffSafe(T obj1, T obj2) {
        return this.columns.stream().map(col -> this.getFieldSafe(obj1, (DataColumn)col)).filter(f -> !Objects.deepEquals(f.getValue(), this.getSafe(obj2, f.getColumn()))).collect(Collectors.toList());
    }

    boolean equals(DataObject obj1, DataObject obj2) {
        return this.equalsSafe(obj1, obj2);
    }

    boolean equalsSafe(T obj1, T obj2) {
        return this.columns.stream().allMatch(col -> Objects.deepEquals(this.getSafe(obj1, (DataColumn)col), this.getSafe(obj2, (DataColumn)col)));
    }
}

