/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.data.model;

import de.inahware.edvj.data.model.DataController;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.query.QueryContext;
import java.util.HashMap;
import java.util.Map;

public class DataModelMap<C extends QueryContext> {
    private Map<String, DataModel<?>> models = new HashMap();
    private Map<String, DataController<?, C>> controllers = new HashMap();

    public DataModelMap<C> with(DataController<?, C> controller) {
        this.insert(controller);
        return this;
    }

    public void insert(DataController<?, C> controller) {
        String name = controller.getModel().getName();
        if (this.models.containsKey(name)) {
            throw new IllegalArgumentException("model name inserted twice: " + name);
        }
        this.models.put(name, controller.getModel());
        this.controllers.put(name, controller);
    }

    public DataModel<?> getModel(String name) {
        return this.models.get(name);
    }

    public <T extends DataObject> DataController<T, C> getController(DataModel<T> model) {
        return this.controllers.get(model.getName());
    }
}

