/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.data.model;

import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.And;
import de.inahware.edvj.query.filter.Filter;
import java.util.List;

public abstract class DataObject {
    public List<DataColumn<?>> getColumns() {
        return this.getModel().getColumns();
    }

    public List<DataColumn<?>> getPrimaryColumns() {
        return this.getModel().getPrimaryIndex();
    }

    public <T> T get(DataColumn<T> col) {
        return this.getModel().get(this, col);
    }

    public <T> void set(DataField<T> field) {
        this.getModel().set(this, field);
    }

    public <T> void set(DataColumn<T> col, T value) {
        this.getModel().set(this, col, value);
    }

    public void update(List<DataField<?>> fields) {
        for (DataField<?> field : fields) {
            this.set(field);
        }
    }

    protected void copyFrom(DataObject obj) {
        this.getModel().copyFrom(this, obj);
    }

    public <T> DataField<T> getField(DataColumn<T> col) {
        return this.getModel().getField(this, col);
    }

    public List<DataField<?>> getFields() {
        return this.getModel().getFields(this);
    }

    public List<DataField<?>> getPrimaryFields() {
        return this.getModel().getPrimaryFields(this);
    }

    public Filter getPrimaryFilter() {
        return new And(this.getPrimaryFields());
    }

    public List<DataField<?>> diff(DataObject obj) {
        if (this.getClass() != obj.getClass()) {
            throw new IllegalArgumentException();
        }
        return this.getModel().diff(this, obj);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.getModel().equals(this, (DataObject)obj);
    }

    public int hashCode() {
        return this.getModel().getColumns().stream().map(col -> this.get((DataColumn)col)).toList().hashCode();
    }

    protected abstract DataModel<?> getModel();
}

