/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.data.model;

import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.request.PermissionContext;
import de.inahware.edvj.request.PermissionException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataQueryGuard {
    private DataModel<?> model;
    private String scope;
    private String select;
    private Integer selectMaxLimit;
    private String insert;
    private Integer insertLimit;
    private String update;
    private Set<DataColumn<?>> updatable;
    private boolean updatePrimaryFilter;
    private String delete;
    private boolean deletePrimaryFilter;

    public DataQueryGuard(DataModel<?> model) {
        this.model = model;
        this.scope = model.getName();
        this.select = ".select";
        this.insert = ".insert";
        this.update = ".update";
        this.updatable = new HashSet();
        this.updatePrimaryFilter = true;
        this.delete = ".delete";
        this.deletePrimaryFilter = true;
    }

    public DataQueryGuard withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public DataQueryGuard withSelectAttribute(String select) {
        this.select = select;
        return this;
    }

    public DataQueryGuard withSelectMaxLimit(Integer limit) {
        this.selectMaxLimit = limit;
        return this;
    }

    public DataQueryGuard withInsertAttribute(String insert) {
        this.insert = insert;
        return this;
    }

    public DataQueryGuard withInsertLimit(Integer limit) {
        this.insertLimit = limit;
        return this;
    }

    public DataQueryGuard withUpdateAttribute(String update) {
        this.update = update;
        return this;
    }

    public DataQueryGuard withUpdatableColumns(DataColumn<?> ... cols) {
        for (DataColumn<?> col : cols) {
            this.updatable.add(col);
        }
        return this;
    }

    public DataQueryGuard withUpdateRequiresPrimaryFilter(boolean primary) {
        this.updatePrimaryFilter = primary;
        return this;
    }

    public DataQueryGuard withDeleteAttribute(String delete) {
        this.delete = delete;
        return this;
    }

    public DataQueryGuard withDeleteRequiresPrimaryFilter(boolean primary) {
        this.deletePrimaryFilter = primary;
        return this;
    }

    private String resolve(String perm) {
        if (perm.startsWith(".")) {
            return this.scope + perm;
        }
        return perm;
    }

    public void onSelectAll(PermissionContext ctx, Filter filter, int offset, int limit) throws Exception {
        if (!ctx.hasPermission(this.resolve(this.select))) {
            throw new PermissionException();
        }
        if (this.selectMaxLimit != null && limit > this.selectMaxLimit) {
            throw new PermissionException();
        }
    }

    public void onInsertAll(PermissionContext ctx, List<?> objs) throws Exception {
        if (!ctx.hasPermission(this.resolve(this.insert))) {
            throw new PermissionException();
        }
        if (this.insertLimit != null && objs.size() > this.insertLimit) {
            throw new PermissionException();
        }
    }

    public void onUpdate(PermissionContext ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        if (!ctx.hasPermission(this.resolve(this.update))) {
            throw new PermissionException();
        }
        for (DataField<?> f : fields) {
            if (this.updatable.contains(f.getColumn())) continue;
            throw new PermissionException();
        }
        if (this.updatePrimaryFilter) {
            Set<DataColumn<?>> cols = filter.getUniqueColumns();
            boolean primary = this.model.getPrimaryIndex().stream().allMatch(c -> cols.contains(c));
            if (!primary) {
                throw new PermissionException();
            }
        }
    }

    public void onDelete(PermissionContext ctx, Filter filter) throws Exception {
        if (!ctx.hasPermission(this.resolve(this.delete))) {
            throw new PermissionException();
        }
        if (this.deletePrimaryFilter) {
            Set<DataColumn<?>> cols = filter.getUniqueColumns();
            boolean primary = this.model.getPrimaryIndex().stream().allMatch(c -> cols.contains(c));
            if (!primary) {
                throw new PermissionException();
            }
        }
    }
}

