/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public abstract class BlockingDialog<T>
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    private JLabel lblMessage;
    private JPanel panel;
    private JProgressBar progressBar;

    public BlockingDialog(Window parent, String title, String message) {
        super(parent);
        this.initialize();
        this.setLocationRelativeTo(parent);
        this.setTitle(title);
        this.lblMessage.setText(message);
    }

    private void initialize() {
        this.setDefaultCloseOperation(0);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setResizable(false);
        this.setSize(450, 110);
        this.getContentPane().setLayout(new MigLayout("", "[grow]", "[grow][23px]"));
        this.lblMessage = new JLabel();
        this.lblMessage.setHorizontalAlignment(0);
        this.getContentPane().add((Component)this.lblMessage, "cell 0 0,alignx center");
        this.panel = new JPanel();
        this.getContentPane().add((Component)this.panel, "cell 0 1,grow");
        this.panel.setLayout(new BorderLayout(0, 0));
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.panel.add(this.progressBar);
    }

    public void setStatus(String status) {
        SwingUtilities.invokeLater(() -> this.lblMessage.setText(status));
    }

    public void setIndeterminate() {
        SwingUtilities.invokeLater(() -> this.progressBar.setIndeterminate(true));
    }

    public void setDeterminate(int min, int max) {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMinimum(min);
            this.progressBar.setMaximum(max);
        });
    }

    public void setProgress(int value) {
        SwingUtilities.invokeLater(() -> this.progressBar.setValue(value));
    }

    public void addProgress(int delta) {
        SwingUtilities.invokeLater(() -> this.progressBar.setValue(this.progressBar.getValue() + delta));
    }

    public void setProgressText(String value) {
        SwingUtilities.invokeLater(() -> {
            if (value == null) {
                this.progressBar.setStringPainted(false);
            } else {
                this.progressBar.setStringPainted(true);
                this.progressBar.setString(value);
            }
        });
    }

    public T input() throws Exception {
        Future<Object> future = EXECUTOR.submit(() -> {
            try {
                T t = this.run();
                return t;
            }
            finally {
                SwingUtilities.invokeLater(() -> this.dispose());
            }
        });
        try {
            try {
                return (T)future.get(250L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                this.setVisible(true);
                return (T)future.get();
            }
        }
        catch (ExecutionException ex) {
            throw (Exception)ex.getCause();
        }
    }

    protected abstract T run() throws Exception;
}

