/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.I18N;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.gui.EditDialog;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public abstract class DataEditDialog<T extends DataObject>
extends EditDialog<T> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = I18N.getBundle();

    protected DataEditDialog() {
    }

    public DataEditDialog(T obj) {
        this(obj, null);
    }

    public DataEditDialog(T obj, T placeholder) {
        super(obj, placeholder);
    }

    @Override
    protected void saveObject(T old, T obj) throws Exception {
        if (old == null) {
            int res = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("edvj.DataEditDialog.messages.confirm"), this.getTitle(), 0, 3);
            if (res != 0) {
                return;
            }
            T obj2 = this.insert(obj);
            this.objectSaved(obj2);
        } else {
            List<DataField<?>> diff = ((DataObject)obj).diff((DataObject)old);
            if (diff.isEmpty()) {
                this.objectSaved(obj);
                return;
            }
            int res = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("edvj.DataEditDialog.messages.confirm_save.text2"), this.getTitle(), 0, 3);
            if (res != 0) {
                return;
            }
            T obj2 = this.update(old, obj, diff);
            this.objectSaved(obj2);
        }
    }

    protected abstract T insert(T var1) throws Exception;

    protected abstract T update(T var1, T var2, List<DataField<?>> var3) throws Exception;
}

