/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.I18N;
import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.gui.DataTablePanel;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.ETable;
import de.inahware.edvj.gui.ETableModelColumn;
import de.inahware.edvj.query.Queryable;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.sql.SQLColumn;
import java.awt.Component;
import java.time.LocalDate;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.function.FailableConsumer;

public class DataTableDialog<T extends DataObject>
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = I18N.getBundle();
    private DataTablePanel<T> panel;
    private T returned;

    public DataTableDialog(DataModel<T> model, Queryable queryable) {
        this.setWindowSize(640, 320);
        this.panel = new DataTablePanel<T>(model, queryable);
        this.add(this.panel, "Center");
        this.addOpenListener(() -> this.panel.refresh());
    }

    public DataTablePanel<T> getPanel() {
        return this.panel;
    }

    public void disableSearch() {
        this.panel.disableSearch();
    }

    public void resetColumns() {
        this.panel.resetColumns();
    }

    public void addSearchColumnInteger(SQLColumn<Integer> col) {
        this.panel.addSearchColumnInteger(col);
    }

    public void addSearchColumnLong(SQLColumn<Long> col) {
        this.panel.addSearchColumnLong(col);
    }

    public void addSearchColumnString(SQLColumn<String> col) {
        this.panel.addSearchColumnString(col);
    }

    public void addSearchColumnDate(SQLColumn<LocalDate> col) {
        this.panel.addSearchColumnDate(col);
    }

    public void addSearchKeyword(String word, DataField<?> field) {
        this.panel.addSearchKeyword(word, field);
    }

    public void addSearchKeyword(DataColumn<?> column, String word, Filter filter) {
        this.panel.addSearchKeyword(column, word, filter);
    }

    public void addSearchKeyword(String title, String word, Filter filter) {
        this.panel.addSearchKeyword(title, word, filter);
    }

    public void addButton(String text, FailableConsumer<T, Exception> action) {
        this.panel.addButton(text, action);
    }

    public void addButton(String text, Predicate<T> cond, FailableConsumer<T, Exception> action) {
        this.panel.addButton(text, cond, action);
    }

    public void addButton(JButton btn) {
        this.panel.addButton(btn);
    }

    public void addCloseButton() {
        this.panel.addButton(this.BUNDLE.getString("edvj.generic.button.close"), obj -> this.close());
    }

    public void addSelectCancelButtons() {
        this.panel.addButton(this.BUNDLE.getString("edvj.generic.button.select"), obj -> obj != null, obj -> {
            this.setReturnedObject(this.getSelectedObject());
            this.close();
        });
        this.panel.addButton(this.BUNDLE.getString("edvj.generic.button.cancel"), obj -> this.close());
    }

    public void setFilter(Filter filter) {
        this.panel.setFilter(filter);
    }

    public Filter getFilter() {
        return this.panel.getFilter();
    }

    public Filter getSearchFilter() {
        return this.panel.getSearchFilter();
    }

    public void addSearchToken(DataColumn<?> column, String value) {
        this.panel.addSearchToken(column, value);
    }

    public void addSearchToken(String column, String value) {
        this.panel.addSearchToken(column, value);
    }

    public void refresh() {
        this.panel.refresh();
    }

    public ETable<T> getTable() {
        return this.panel.getTable();
    }

    public T getSelectedObject() {
        return this.panel.getSelectedObject();
    }

    protected void setReturnedObject(T obj) {
        this.returned = obj;
    }

    public T getReturnedObject() {
        return this.returned;
    }

    public <U> void addColumn(DataColumn<U> col) {
        this.panel.addColumn(col);
    }

    public <U> void addColumn(DataColumn<U> col, Function<U, Object> formatValue) {
        this.panel.addColumn(col, formatValue);
    }

    public <U> void addColumn(DataColumn<U> col, Class<?> cls, Function<U, Object> formatValue) {
        this.panel.addColumn(col, cls, formatValue);
    }

    public <U> void addColumn(DataColumn<U> col, Function<U, Object> formatValue, Function<Object, U> parseValue) {
        this.panel.addColumn(col, formatValue, parseValue);
    }

    public <U> void addColumn(DataColumn<U> col, Class<?> cls, Function<U, Object> formatValue, Function<Object, U> parseValue) {
        this.panel.addColumn(col, cls, formatValue, parseValue);
    }

    public <U> void addColumn(DataColumn<U> col, Function<U, Object> formatValue, Function<Object, U> parseValue, Predicate<T> isEditable) {
        this.panel.addColumn(col, formatValue, parseValue, isEditable);
    }

    public <U> void addColumn(DataColumn<U> col, Class<?> cls, Function<U, Object> formatValue, Function<Object, U> parseValue, Predicate<T> isEditable) {
        this.panel.addColumn(col, cls, formatValue, parseValue, isEditable);
    }

    public void addColumn(ETableModelColumn<T> col) {
        this.panel.addColumn(col);
    }

    public void addColumn(String title, Function<T, Object> getValue) {
        this.panel.addColumn(title, getValue);
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue) {
        this.panel.addColumn(title, cls, getValue);
    }

    public void addColumn(String title, Function<T, Object> getValue, BiConsumer<T, Object> setValue) {
        this.panel.addColumn(title, getValue, setValue);
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue, BiConsumer<T, Object> setValue) {
        this.panel.addColumn(title, cls, getValue, setValue);
    }

    public void addColumn(String title, Function<T, Object> getValue, Predicate<T> isEditable, BiConsumer<T, Object> setValue) {
        this.panel.addColumn(title, getValue, isEditable, setValue);
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue, Predicate<T> isEditable, BiConsumer<T, Object> setValue) {
        this.panel.addColumn(title, cls, getValue, isEditable, setValue);
    }

    public void addSelectAction(FailableConsumer<T, Exception> action) {
        this.panel.addSelectAction(action);
    }

    public void addDoubleClickAction(FailableConsumer<T, Exception> action) {
        this.panel.addDoubleClickAction(action);
    }

    public void addSelectDoubleClickAction() {
        this.addDoubleClickAction(obj -> {
            if (obj != null) {
                this.setReturnedObject(obj);
                this.close();
            }
        });
    }

    public void addPopupMenuItem(JMenuItem item) {
        this.panel.addPopupMenuItem(item);
    }

    public void addPopupMenuItem(String text, FailableConsumer<T, Exception> action) {
        this.panel.addPopupMenuItem(text, action);
    }

    public void addPopupMenuItem(String text, Predicate<T> cond, FailableConsumer<T, Exception> action) {
        this.panel.addPopupMenuItem(text, cond, action);
    }

    public void connect(AbstractButton btn, FailableConsumer<T, Exception> action) {
        this.panel.connect(btn, action);
    }

    public void connect(AbstractButton btn, Predicate<T> cond, FailableConsumer<T, Exception> action) {
        this.panel.connect(btn, cond, action);
    }

    public T inputDialog(Component parent) {
        this.intoModalDialog(parent).setVisible(true);
        return this.returned;
    }

    public void inputPage(EFrame parent, FailableConsumer<T, Exception> action) {
        this.openPage(parent, () -> action.accept(this.returned));
    }

    public void inputInnerModal(EFrame parent, FailableConsumer<T, Exception> action) {
        this.openInnerModal(parent, () -> action.accept(this.returned));
    }
}

