/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.I18N;
import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.gui.DateRangeDialog;
import de.inahware.edvj.gui.EDataTable;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.ETable;
import de.inahware.edvj.gui.ETableModelColumn;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Queryable;
import de.inahware.edvj.query.SelectAll;
import de.inahware.edvj.query.filter.And;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.query.filter.Like;
import de.inahware.edvj.query.filter.Or;
import de.inahware.edvj.query.filter.Span;
import de.inahware.edvj.sql.SQLColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.function.FailableConsumer;

public class DataTablePanel<T extends DataObject>
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = I18N.getBundle();
    private DataModel<T> model;
    private Queryable queryable;
    private Filter filter;
    private Filter searchFilter;
    private Map<String, DataColumn<Integer>> cols_search_int;
    private Map<String, DataColumn<Long>> cols_search_long;
    private Map<String, DataColumn<String>> cols_search_string;
    private Map<String, DataColumn<LocalDate>> cols_search_date;
    private Map<String, Map<String, Filter>> cols_search_keywords;
    private JPopupMenu mnu_filters;
    private Map<String, JMenu> cols_menus;
    private List<JButton> buttons;
    private JPanel panel_top;
    private JLabel lblSearch;
    private ETextField textField;
    private JButton btnFilters;
    private JPanel panel;
    private JScrollPane scrollPane;
    private EDataTable<T> table;
    private JPanel panel_bottom;
    private JProgressBar progressBar;
    private JPanel panel_buttons;
    private Timer timer;
    private Instant t_edit;

    public DataTablePanel(DataModel<T> model, Queryable queryable) {
        this.model = model;
        this.queryable = queryable;
        this.filter = null;
        this.searchFilter = null;
        this.cols_search_int = new HashMap<String, DataColumn<Integer>>();
        this.cols_search_long = new HashMap<String, DataColumn<Long>>();
        this.cols_search_string = new HashMap<String, DataColumn<String>>();
        this.cols_search_date = new HashMap<String, DataColumn<LocalDate>>();
        this.cols_search_keywords = new HashMap<String, Map<String, Filter>>();
        this.mnu_filters = new JPopupMenu();
        this.cols_menus = new HashMap<String, JMenu>();
        this.buttons = new ArrayList<JButton>();
        this.initialize();
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            private void changed() {
                DataTablePanel.this.t_edit = Instant.now();
            }
        });
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTablePanel.this.t_edit = null;
                DataTablePanel.this.refresh();
            }
        });
        this.btnFilters.addActionListener(ev -> this.mnu_filters.show(this.btnFilters, 0, this.btnFilters.getHeight()));
        this.timer = new Timer(100, e -> {
            if (this.t_edit != null && Duration.between(this.t_edit, Instant.now()).toMillis() >= 500L) {
                this.t_edit = null;
                this.refresh();
            }
        });
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.panel_top = new JPanel();
        this.panel_top.setLayout(new MigLayout("", "[][grow][]", "[]0"));
        this.add((Component)this.panel_top, "North");
        this.lblSearch = new JLabel(this.BUNDLE.getString("edvj.generic.label.search") + ":");
        this.panel_top.add((Component)this.lblSearch, "cell 0 0,alignx trailing");
        this.textField = new ETextField();
        this.panel_top.add((Component)this.textField, "cell 1 0,growx");
        this.textField.setColumns(10);
        this.btnFilters = new JButton(this.BUNDLE.getString("edvj.generic.button.filters"));
        this.panel_top.add((Component)this.btnFilters, "cell 2 0");
        this.panel = new JPanel();
        this.panel.setLayout(new MigLayout("", "[grow]", "[grow][23px:n]"));
        this.add((Component)this.panel, "Center");
        this.scrollPane = new JScrollPane();
        this.panel.add((Component)this.scrollPane, "cell 0 0,grow");
        this.table = new EDataTable<T>(this.model);
        this.table.setFillsViewportHeight(true);
        this.scrollPane.setViewportView(this.table);
        this.panel_bottom = new JPanel();
        this.panel.add((Component)this.panel_bottom, "cell 0 1,grow");
        this.panel_bottom.setLayout(new BorderLayout(0, 0));
        this.progressBar = new JProgressBar();
        this.progressBar.setValue(100);
        this.panel_bottom.add(this.progressBar);
        this.progressBar.setMaximumSize(null);
        this.progressBar.setPreferredSize(null);
    }

    public void disableSearch() {
        this.remove(this.panel_top);
    }

    public void addSearchColumnInteger(SQLColumn<Integer> col) {
        String title = this.getColumnTitle(col);
        this.cols_search_int.put(title.toLowerCase(), col);
        JMenuItem item = new JMenuItem(title);
        item.addActionListener(ev -> {
            String input = "";
            while ((input = JOptionPane.showInputDialog(this, "input", input)) != null && !input.isEmpty()) {
                try {
                    int n = Integer.parseInt(input);
                    this.addSearchToken(title, "" + n);
                    return;
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "invalid number", "input", 0);
                    continue;
                }
                break;
            }
            return;
        });
        this.mnu_filters.add(item);
    }

    public void addSearchColumnLong(SQLColumn<Long> col) {
        String title = this.getColumnTitle(col);
        this.cols_search_long.put(title.toLowerCase(), col);
        JMenuItem item = new JMenuItem(title);
        item.addActionListener(ev -> {
            String input = "";
            while ((input = JOptionPane.showInputDialog(this, "input", input)) != null && !input.isEmpty()) {
                try {
                    long n = Long.parseLong(input);
                    this.addSearchToken(title, "" + n);
                    return;
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "invalid number", "input", 0);
                    continue;
                }
                break;
            }
            return;
        });
        this.mnu_filters.add(item);
    }

    public void addSearchColumnString(SQLColumn<String> col) {
        String title = this.getColumnTitle(col);
        this.cols_search_string.put(title.toLowerCase(), col);
        JMenuItem item = new JMenuItem(title);
        item.addActionListener(ev -> {
            String input = JOptionPane.showInputDialog(this, (Object)"input");
            if (input == null || input.isEmpty()) {
                return;
            }
            this.addSearchToken(title, input);
        });
        this.mnu_filters.add(item);
    }

    public void addSearchColumnDate(SQLColumn<LocalDate> col) {
        String title = this.getColumnTitle(col);
        this.cols_search_date.put(title.toLowerCase(), col);
        JMenuItem item = new JMenuItem(title);
        item.addActionListener(ev -> {
            DateRangeDialog.Result res = (DateRangeDialog.Result)new DateRangeDialog().inputDialog(this);
            if (res == null) {
                return;
            }
            if (!res.isRange()) {
                this.addSearchToken(title, I18N.formatDate(res.getDate()));
            } else {
                this.addSearchToken(title, I18N.formatDate(res.getFrom()) + "-" + I18N.formatDate(res.getUntil()));
            }
        });
        this.mnu_filters.add(item);
    }

    public void addSearchKeyword(String word, DataField<?> field) {
        this.addSearchKeyword(field.getColumn(), word, field);
    }

    public void addSearchKeyword(DataColumn<?> column, String word, Filter filter) {
        this.addSearchKeyword(this.getColumnTitle(column), word, filter);
    }

    public void addSearchKeyword(String title, String word, Filter filter) {
        String name = title.toLowerCase();
        if (!this.cols_search_keywords.containsKey(name)) {
            this.cols_search_keywords.put(name, new HashMap());
        }
        this.cols_search_keywords.get(name).put(word.toLowerCase(), filter);
        if (!this.cols_menus.containsKey(name)) {
            JMenu mnu = new JMenu(title);
            this.mnu_filters.add(mnu);
            this.cols_menus.put(name, mnu);
        }
        JMenuItem item = new JMenuItem(word);
        item.addActionListener(ev -> this.addSearchToken(title, word));
        this.cols_menus.get(name).add(item);
    }

    private String getColumnTitle(DataColumn<?> col) {
        return col.getLocalizedString(this.model, this.BUNDLE);
    }

    public void addButton(JButton btn) {
        this.buttons.add(btn);
        if (this.panel_buttons != null) {
            this.panel_bottom.remove(this.panel_buttons);
        }
        this.panel_buttons = new JPanel();
        this.panel_buttons.setLayout(new MigLayout("", "[]".repeat(this.buttons.size()) + "0", "0[]0"));
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.panel_buttons.add((Component)this.buttons.get(i), "cell " + i + " 0");
        }
        this.panel_bottom.add((Component)this.panel_buttons, "East");
    }

    public void addButton(String text, FailableConsumer<T, Exception> action) {
        JButton btn = new JButton(text);
        this.connect(btn, action);
        this.addButton(btn);
    }

    public void addButton(String text, Predicate<T> cond, FailableConsumer<T, Exception> action) {
        JButton btn = new JButton(text);
        this.connect(btn, cond, action);
        this.addButton(btn);
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Filter getSearchFilter() {
        return this.searchFilter;
    }

    public void addSearchToken(DataColumn<?> column, String value) {
        this.addSearchToken(this.getColumnTitle(column), value);
    }

    public void addSearchToken(String column, String value) {
        String token = "\"" + column + ":" + value + "\"";
        Object text = this.textField.getText();
        if (((String)text).isEmpty()) {
            this.textField.setText(token);
        } else {
            Pattern pattern = Pattern.compile("([^\\s\"][^\\s]*|\"[^\"]*\")");
            Matcher matcher = pattern.matcher(this.textField.getText());
            while (matcher.find()) {
                String next = matcher.group();
                if (next.startsWith("\"")) {
                    next = next.substring(1, next.length() - 1);
                }
                if (next.isEmpty() || !next.toLowerCase().startsWith(column.toLowerCase() + ":")) continue;
                text = ((String)text).substring(0, matcher.start()) + token + ((String)text).substring(matcher.end());
                this.textField.setText((String)text);
                return;
            }
            this.textField.setText(this.textField.getText() + " " + token);
        }
        this.refresh();
    }

    public void refresh() {
        this.t_edit = null;
        this.timer.stop();
        this.table.setEnabled(false);
        this.progressBar.setIndeterminate(true);
        new Thread(() -> EUtils.catchWithDialog(this, () -> {
            List<T> data = this.query();
            SwingUtilities.invokeLater(() -> {
                this.timer.start();
                this.table.setData(data);
                this.table.setEnabled(true);
                this.progressBar.setIndeterminate(false);
            });
        })).start();
    }

    private List<T> query() throws Exception {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (this.filter != null) {
            filters.add(this.filter);
        }
        Pattern pattern = Pattern.compile("([^\\s\"][^\\s]*|\"[^\"]*\")");
        Matcher matcher = pattern.matcher(this.textField.getText());
        while (matcher.find()) {
            Filter filter;
            String token = matcher.group();
            if (token.startsWith("\"")) {
                token = token.substring(1, token.length() - 1);
            }
            if (token.isEmpty() || (filter = this.filterFromToken(token)) == null) continue;
            filters.add(filter);
        }
        this.searchFilter = new And(filters);
        return (List)this.queryable.query(new SelectAll<T>(this.model, this.searchFilter));
    }

    private Filter filterFromToken(String token) {
        if (token.contains(":")) {
            String[] split = token.split(":", 2);
            String name = split[0].toLowerCase();
            String value = split[1];
            if (this.cols_search_int.containsKey(name)) {
                DataColumn<Integer> dataColumn = this.cols_search_int.get(name);
                try {
                    int n = Integer.parseInt(value);
                    return dataColumn.with(n);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if (this.cols_search_long.containsKey(name)) {
                DataColumn<Long> dataColumn = this.cols_search_long.get(name);
                try {
                    long l = Long.parseLong(value);
                    return dataColumn.with(l);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if (this.cols_search_string.containsKey(name)) {
                return new Like(this.cols_search_string.get(name), "%" + (String)value + "%");
            }
            if (this.cols_search_date.containsKey(name)) {
                DataColumn<LocalDate> dataColumn = this.cols_search_date.get(name);
                String[] stringArray = value.split("-");
                if (stringArray.length == 2) {
                    LocalDate localDate = this.parseDate(stringArray[0], false);
                    LocalDate end = this.parseDate(stringArray[1], true);
                    if (localDate == null || end == null) {
                        return null;
                    }
                    return new Span<LocalDate>(dataColumn, localDate, end);
                }
                LocalDate localDate = this.parseDate(value, false);
                if (localDate == null) {
                    return null;
                }
                LocalDate end = this.parseDate(value, true);
                return new Span<LocalDate>(dataColumn, localDate, end);
            }
            if (this.cols_search_keywords.containsKey(name)) {
                Map<String, Filter> map = this.cols_search_keywords.get(name);
                if (map.containsKey(value)) {
                    return map.get(value);
                }
                ArrayList<Filter> arrayList = new ArrayList<Filter>();
                for (Map.Entry<String, Filter> entry : map.entrySet()) {
                    if (!entry.getKey().startsWith(value.toLowerCase())) continue;
                    arrayList.add(entry.getValue());
                }
                if (arrayList.isEmpty()) {
                    return null;
                }
                return new Or(arrayList);
            }
        }
        ArrayList<Filter> fs = new ArrayList<Filter>();
        try {
            int n = Integer.parseInt(token);
            for (DataColumn dataColumn : this.cols_search_int.values()) {
                fs.add(dataColumn.with(n));
            }
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        try {
            long n = Long.parseLong(token);
            for (DataColumn<Long> dataColumn : this.cols_search_long.values()) {
                fs.add(dataColumn.with(n));
            }
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        for (DataColumn<String> c : this.cols_search_string.values()) {
            fs.add(new Like(c, "%" + token + "%"));
        }
        String[] split = token.split("-");
        if (split.length == 2) {
            LocalDate begin = this.parseDate(split[0], false);
            LocalDate localDate = this.parseDate(split[1], true);
            if (begin != null && localDate != null) {
                for (DataColumn<LocalDate> dataColumn : this.cols_search_date.values()) {
                    fs.add(new Span<LocalDate>(dataColumn, begin, localDate));
                }
            }
        } else {
            LocalDate date = this.parseDate(token, false);
            if (date != null) {
                LocalDate localDate = this.parseDate(token, true);
                for (DataColumn<LocalDate> dataColumn : this.cols_search_date.values()) {
                    fs.add(new Span<LocalDate>(dataColumn, date, localDate));
                }
            }
        }
        for (Map<String, Filter> map : this.cols_search_keywords.values()) {
            if (map.containsKey(token)) {
                fs.add(map.get(token));
                continue;
            }
            for (Map.Entry<String, Filter> entry : map.entrySet()) {
                if (!entry.getKey().startsWith(token.toLowerCase())) continue;
                fs.add(entry.getValue());
            }
        }
        return new Or(fs);
    }

    private LocalDate parseDate(String str, boolean end) {
        try {
            LocalDate date = I18N.parseDate(str);
            if (end) {
                return date.plusDays(1L);
            }
            return date;
        }
        catch (DateTimeParseException date) {
            try {
                LocalDate date2 = I18N.parseYearMonth(str);
                if (end) {
                    return date2.plusMonths(1L);
                }
                return date2;
            }
            catch (DateTimeParseException date2) {
                try {
                    LocalDate date3 = I18N.parseYear(str);
                    if (end) {
                        return date3.plusYears(1L);
                    }
                    return date3;
                }
                catch (DateTimeParseException dateTimeParseException) {
                    return null;
                }
            }
        }
    }

    public ETable<T> getTable() {
        return this.table;
    }

    public T getSelectedObject() {
        return (T)((DataObject)this.table.getSelectedObject());
    }

    public void resetColumns() {
        this.table.resetColumns();
    }

    public <U> void addColumn(DataColumn<U> col) {
        this.table.addColumn(col);
    }

    public <U> void addColumn(DataColumn<U> col, Function<U, Object> formatValue) {
        this.table.addColumn(col, formatValue);
    }

    public <U> void addColumn(DataColumn<U> col, Class<?> cls, Function<U, Object> formatValue) {
        this.table.addColumn(col, cls, formatValue);
    }

    public <U> void addColumn(DataColumn<U> col, Function<U, Object> formatValue, Function<Object, U> parseValue) {
        this.table.addColumn(col, formatValue, parseValue);
    }

    public <U> void addColumn(DataColumn<U> col, Class<?> cls, Function<U, Object> formatValue, Function<Object, U> parseValue) {
        this.table.addColumn(col, cls, formatValue, parseValue);
    }

    public <U> void addColumn(DataColumn<U> col, Function<U, Object> formatValue, Function<Object, U> parseValue, Predicate<T> isEditable) {
        this.table.addColumn(col, formatValue, parseValue, isEditable);
    }

    public <U> void addColumn(DataColumn<U> col, Class<?> cls, Function<U, Object> formatValue, Function<Object, U> parseValue, Predicate<T> isEditable) {
        this.table.addColumn(col, cls, formatValue, parseValue, isEditable);
    }

    public void addColumn(ETableModelColumn<T> col) {
        ((ETable)this.table).addColumn(col);
    }

    public void addColumn(String title, Function<T, Object> getValue) {
        this.table.addColumn(title, getValue);
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue) {
        this.table.addColumn(title, cls, getValue);
    }

    public void addColumn(String title, Function<T, Object> getValue, BiConsumer<T, Object> setValue) {
        this.table.addColumn(title, getValue, setValue);
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue, BiConsumer<T, Object> setValue) {
        this.table.addColumn(title, cls, getValue, setValue);
    }

    public void addColumn(String title, Function<T, Object> getValue, Predicate<T> isEditable, BiConsumer<T, Object> setValue) {
        this.table.addColumn(title, getValue, setValue, isEditable);
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue, Predicate<T> isEditable, BiConsumer<T, Object> setValue) {
        this.table.addColumn(title, cls, getValue, setValue, isEditable);
    }

    public void addSelectAction(FailableConsumer<T, Exception> action) {
        this.table.addSelectAction(action);
    }

    public void addDoubleClickAction(FailableConsumer<T, Exception> action) {
        this.table.addDoubleClickAction(action);
    }

    public void addPopupMenuItem(JMenuItem item) {
        this.table.addPopupMenuItem(item);
    }

    public void addPopupMenuItem(String text, FailableConsumer<T, Exception> action) {
        this.table.addPopupMenuItem(text, action);
    }

    public void addPopupMenuItem(String text, Predicate<T> cond, FailableConsumer<T, Exception> action) {
        this.table.addPopupMenuItem(text, cond, action);
    }

    public void connect(AbstractButton btn, FailableConsumer<T, Exception> action) {
        this.table.connect(btn, action);
    }

    public void connect(AbstractButton btn, Predicate<T> cond, FailableConsumer<T, Exception> action) {
        this.table.connect(btn, cond, action);
    }
}

