/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import com.github.lgooddatepicker.components.DatePicker;
import de.inahware.edvj.gui.InputDialog;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.time.LocalDate;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import net.miginfocom.swing.MigLayout;

public class DateRangeDialog
extends InputDialog<Result> {
    private static final long serialVersionUID = 1L;
    private JPanel panel_choose;
    private JRadioButton rdSingle;
    private JRadioButton rdRange;
    private JPanel panel_input;
    private JPanel panel_single;
    private JLabel lblDate;
    private DatePicker datePicker;
    private JPanel panel_range;
    private JLabel lblFrom;
    private DatePicker dateFrom;
    private JLabel lblUntil;
    private DatePicker dateUntil;
    private JSeparator separator;

    public DateRangeDialog() {
        this.setPacking(true);
        this.initialize();
        this.rdSingle.addChangeListener(this::rdChanged);
        this.rdRange.addChangeListener(this::rdChanged);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdSingle);
        group.add(this.rdRange);
        this.rdSingle.setSelected(true);
    }

    private void rdChanged(ChangeEvent ev) {
        CardLayout card = (CardLayout)this.panel_input.getLayout();
        if (this.rdSingle.isSelected()) {
            card.show(this.panel_input, "single");
        } else if (this.rdRange.isSelected()) {
            card.show(this.panel_input, "range");
        }
    }

    private void initialize() {
        this.setTitle("input date range");
        this.rootPanel.setLayout(new MigLayout("", "[grow]", "[][][]"));
        this.panel_choose = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel_choose.getLayout();
        flowLayout.setAlignment(0);
        this.rootPanel.add((Component)this.panel_choose, "cell 0 0,grow");
        this.rdSingle = new JRadioButton("single date");
        this.panel_choose.add(this.rdSingle);
        this.rdRange = new JRadioButton("date range");
        this.panel_choose.add(this.rdRange);
        this.separator = new JSeparator();
        this.rootPanel.add((Component)this.separator, "cell 0 1,growx");
        this.panel_input = new JPanel();
        this.rootPanel.add((Component)this.panel_input, "cell 0 2,grow");
        this.panel_input.setLayout(new CardLayout(0, 0));
        this.panel_single = new JPanel();
        this.panel_input.add((Component)this.panel_single, "single");
        this.panel_single.setLayout(new MigLayout("", "[][grow]", "[]"));
        this.lblDate = new JLabel("Date:");
        this.panel_single.add((Component)this.lblDate, "cell 0 0,alignx trailing");
        this.datePicker = new DatePicker();
        this.panel_single.add((Component)this.datePicker, "cell 1 0,growx");
        this.panel_range = new JPanel();
        this.panel_input.add((Component)this.panel_range, "range");
        this.panel_range.setLayout(new MigLayout("", "[][grow]", "[][]"));
        this.lblFrom = new JLabel("From:");
        this.panel_range.add((Component)this.lblFrom, "cell 0 0,alignx trailing");
        this.dateFrom = new DatePicker();
        this.panel_range.add((Component)this.dateFrom, "cell 1 0,growx");
        this.lblUntil = new JLabel("Until:");
        this.panel_range.add((Component)this.lblUntil, "cell 0 1,alignx trailing");
        this.dateUntil = new DatePicker();
        this.panel_range.add((Component)this.dateUntil, "cell 1 1,growx");
    }

    @Override
    protected Result parseObject() throws Exception {
        if (this.rdSingle.isSelected()) {
            LocalDate res = this.datePicker.getDate();
            if (res == null) {
                throw new RuntimeException("no date selected");
            }
            return new Result(res);
        }
        if (this.rdRange.isSelected()) {
            LocalDate from = this.dateFrom.getDate();
            if (from == null) {
                throw new RuntimeException("no date selected");
            }
            LocalDate until = this.dateUntil.getDate();
            if (until == null) {
                throw new RuntimeException("no date selected");
            }
            return new Result(from, until);
        }
        return null;
    }

    public static class Result {
        private boolean range;
        private LocalDate date;
        private LocalDate from;
        private LocalDate until;

        public Result(LocalDate date) {
            this.range = false;
            this.date = date;
            this.from = null;
            this.until = null;
        }

        public Result(LocalDate from, LocalDate until) {
            this.range = true;
            this.date = null;
            this.from = from;
            this.until = until;
        }

        public boolean isRange() {
            return this.range;
        }

        public LocalDate getDate() {
            return this.date;
        }

        public LocalDate getFrom() {
            return this.from;
        }

        public LocalDate getUntil() {
            return this.until;
        }
    }
}

