/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.gui.BlockingDialog;
import de.inahware.edvj.gui.DataEditDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Insert;
import de.inahware.edvj.query.Queryable;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.Update;
import java.awt.Component;
import java.util.List;

public abstract class DefaultDataEditDialog<T extends DataObject>
extends DataEditDialog<T> {
    private static final long serialVersionUID = 1L;
    private final DataModel<T> model;
    private Queryable queryable;

    protected DefaultDataEditDialog() {
        this.model = null;
    }

    public DefaultDataEditDialog(DataModel<T> model, Queryable queryable, T obj) {
        this((DataModel<Object>)model, queryable, obj, null);
    }

    public DefaultDataEditDialog(DataModel<T> model, Queryable queryable, T obj, T placeholder) {
        super(obj, placeholder);
        this.model = model;
        this.queryable = queryable;
    }

    public Queryable getQueryable() {
        return this.queryable;
    }

    @Override
    protected T insert(T obj) throws Exception {
        return (T)EUtils.blocking((Component)this, blocking -> this.insert((BlockingDialog<T>)blocking, obj));
    }

    protected T insert(BlockingDialog<T> blocking, T obj) throws Exception {
        return (T)((DataObject)this.queryable.query(new Insert<T>(this.model, obj)));
    }

    @Override
    protected T update(T old, T obj, List<DataField<?>> diff) throws Exception {
        return (T)EUtils.blocking((Component)this, blocking -> this.update((BlockingDialog<T>)blocking, old, obj, diff));
    }

    protected T update(BlockingDialog<T> blocking, T old, T obj, List<DataField<?>> diff) throws Exception {
        this.queryable.query(new Update<T>(this.model, diff, ((DataObject)old).getPrimaryFilter()));
        return (T)((DataObject)this.queryable.query(new Select<T>(this.model, ((DataObject)obj).getPrimaryFilter())));
    }
}

