/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.I18N;
import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.gui.ETable;
import de.inahware.edvj.gui.ETableModel;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.function.Predicate;

public class EDataTable<T extends DataObject>
extends ETable<T> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = I18N.getBundle();
    private DataModel<T> model;

    public EDataTable(DataModel<T> model) {
        this.model = model;
    }

    public EDataTable(DataModel<T> model, List<T> data) {
        super(data);
        this.model = model;
    }

    public EDataTable(DataModel<T> model, ETableModel<T> tableModel) {
        super(tableModel);
        this.model = model;
    }

    @Override
    public <U> void addColumn(DataColumn<U> col) {
        this.addColumn(col.getLocalizedString(this.model, this.BUNDLE), col.getValueClass(), (T obj) -> obj.get(col));
    }

    public <U> void addColumn(DataColumn<U> col, Function<U, Object> formatValue) {
        this.addColumn(col.getLocalizedString(this.model, this.BUNDLE), (T obj) -> formatValue.apply(obj.get(col)));
    }

    public <U> void addColumn(DataColumn<U> col, Class<?> cls, Function<U, Object> formatValue) {
        this.addColumn(col.getLocalizedString(this.model, this.BUNDLE), cls, (T obj) -> formatValue.apply(obj.get(col)));
    }

    public <U> void addColumn(DataColumn<U> col, Function<U, Object> formatValue, Function<Object, U> parseValue) {
        this.addColumn(col.getLocalizedString(this.model, this.BUNDLE), (T obj) -> formatValue.apply(obj.get(col)), (T obj, Object value) -> obj.set(col, parseValue.apply(value)));
    }

    public <U> void addColumn(DataColumn<U> col, Class<?> cls, Function<U, Object> formatValue, Function<Object, U> parseValue) {
        this.addColumn(col.getLocalizedString(this.model, this.BUNDLE), cls, (T obj) -> formatValue.apply(obj.get(col)), (T obj, Object value) -> obj.set(col, parseValue.apply(value)));
    }

    public <U> void addColumn(DataColumn<U> col, Function<U, Object> formatValue, Function<Object, U> parseValue, Predicate<T> isEditable) {
        this.addColumn(col.getLocalizedString(this.model, this.BUNDLE), (T obj) -> formatValue.apply(obj.get(col)), (T obj, Object value) -> obj.set(col, parseValue.apply(value)), isEditable);
    }

    public <U> void addColumn(DataColumn<U> col, Class<?> cls, Function<U, Object> formatValue, Function<Object, U> parseValue, Predicate<T> isEditable) {
        this.addColumn(col.getLocalizedString(this.model, this.BUNDLE), cls, (T obj) -> formatValue.apply(obj.get(col)), (T obj, Object value) -> obj.set(col, parseValue.apply(value)), isEditable);
    }
}

