/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.EUtils;
import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;

public class EFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = I18N.getBundle();
    private boolean appendSuffix = true;

    public EFileChooser() {
    }

    public EFileChooser(Path currentDirectory) {
        super(currentDirectory.toFile());
    }

    public EFileChooser(Path currentDirectory, FileSystemView fsv) {
        super(currentDirectory.toFile(), fsv);
    }

    public EFileChooser(FileSystemView fsv) {
        super(fsv);
    }

    public void addDefaultFilter(String name, String ... ext) {
        this.setFileFilter(new FileNameExtensionFilter(name, ext));
    }

    public void addFilter(String name, String ... ext) {
        this.addChoosableFileFilter(new FileNameExtensionFilter(name, ext));
    }

    public boolean getAppendSuffix() {
        return this.appendSuffix;
    }

    public void setAppendSuffix(boolean appendSuffix) {
        this.appendSuffix = appendSuffix;
    }

    public Path open(Component parent) {
        int answer = this.showOpenDialog(parent);
        if (answer != 0) {
            return null;
        }
        return this.getSelectedFile().toPath();
    }

    public Path save(Component parent) {
        int answer = this.showSaveDialog(parent);
        if (answer != 0) {
            return null;
        }
        return this.getSelectedFile().toPath();
    }

    @Override
    public void approveSelection() {
        int answer;
        FileFilter fileFilter;
        File f = this.getSelectedFile();
        if (this.appendSuffix && (fileFilter = this.getFileFilter()) instanceof FileNameExtensionFilter) {
            FileNameExtensionFilter filter = (FileNameExtensionFilter)fileFilter;
            if (FilenameUtils.getExtension(f.toString()).isEmpty()) {
                f = new File(f.toString() + "." + filter.getExtensions()[0]);
                this.setSelectedFile(f);
            }
        }
        if (this.getDialogType() == 0 && !f.exists()) {
            EUtils.showErrorDialog((Component)this, this.BUNDLE.getString("edvj.EFileChooser.messages.file_not_found"));
            return;
        }
        if (this.getDialogType() == 1 && f.exists() && (answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("edvj.EFileChooser.messages.confirm_overwrite.text1") + " " + f.getName() + " " + this.BUNDLE.getString("edvj.EFileChooser.messages.confirm_overwrite.text2"), this.getDialogTitle(), 0)) != 0) {
            return;
        }
        super.approveSelection();
    }
}

