/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.gui.ENavigatorPane;
import de.inahware.edvj.gui.EUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.commons.lang3.function.FailableRunnable;

public class EFrame
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String title;
    private Image icon;
    private Dimension windowSize = new Dimension(300, 300);
    private Dimension windowMinSize;
    private boolean resizable = true;
    private boolean maximized = false;
    private boolean packing = false;
    private JMenuBar menuBar = null;
    private JButton defaultButton = null;
    private List<FailableRunnable<Exception>> changeListeners = new ArrayList<FailableRunnable<Exception>>();
    private List<FailableRunnable<Exception>> openListeners = new ArrayList<FailableRunnable<Exception>>();
    private List<FailableRunnable<Exception>> closingListeners = new ArrayList<FailableRunnable<Exception>>();
    private List<FailableRunnable<Exception>> closedListeners = new ArrayList<FailableRunnable<Exception>>();
    private List<FailableRunnable<Exception>> closedByUserListeners = new ArrayList<FailableRunnable<Exception>>();
    private EFrame parent;
    private List<EFrame> children = new ArrayList<EFrame>();
    private JFrame frameInstance;
    private JDialog dialogInstance;
    private JInternalFrame internalFrameInstance;
    private boolean opened = false;
    private boolean closing = false;
    private JLayeredPane glass;
    private JDesktopPane desktop;

    public EFrame() {
        this("");
    }

    public EFrame(String title) {
        this.title = title;
        this.setLayout(new BorderLayout());
    }

    public void setTitle(String title) {
        this.title = title;
        this.fireChangeEvent();
    }

    public String getTitle() {
        return this.title;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public Image getIcon() {
        return this.icon;
    }

    public Dimension getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(Dimension windowSize) {
        this.windowSize = windowSize;
    }

    public void setWindowSize(int width, int height) {
        this.setWindowSize(new Dimension(width, height));
    }

    public Dimension getWindowMinSize() {
        return this.windowMinSize;
    }

    public void setWindowMinSize(Dimension windowMinSize) {
        this.windowMinSize = windowMinSize;
    }

    public void setWindowMinSize(int width, int height) {
        this.setWindowMinSize(new Dimension(width, height));
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMaximized(boolean maximized) {
        this.maximized = maximized;
    }

    public boolean isPacking() {
        return this.packing;
    }

    public void setPacking(boolean packing) {
        this.packing = packing;
    }

    public void setMenuBar(JMenuBar menuBar) {
        this.menuBar = menuBar;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setDefaultButton(JButton defaultButton) {
        this.defaultButton = defaultButton;
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    public void addChangeListener(FailableRunnable<Exception> run) {
        this.changeListeners.add(run);
    }

    public void removeChangeListener(FailableRunnable<Exception> run) {
        this.changeListeners.remove(run);
    }

    public void addOpenListener(FailableRunnable<Exception> run) {
        this.openListeners.add(run);
    }

    public void removeOpenListener(FailableRunnable<Exception> run) {
        this.openListeners.remove(run);
    }

    public void addClosingListener(FailableRunnable<Exception> run) {
        this.closingListeners.add(run);
    }

    public void removeClosingListener(FailableRunnable<Exception> run) {
        this.closingListeners.remove(run);
    }

    public void addClosedListener(FailableRunnable<Exception> run) {
        this.closedListeners.add(run);
    }

    public void removeClosedListener(FailableRunnable<Exception> run) {
        this.closedListeners.remove(run);
    }

    public void addClosedByUserListener(FailableRunnable<Exception> run) {
        this.closedByUserListeners.add(run);
    }

    public void removeClosedByUserListener(FailableRunnable<Exception> run) {
        this.closedByUserListeners.remove(run);
    }

    protected void fireChangeEvent() {
        for (FailableRunnable<Exception> listener : this.changeListeners) {
            EUtils.catchWithDialog(this, listener);
        }
    }

    protected void fireOpenEvent() {
        System.err.println("[" + System.identityHashCode(this) + " \"" + this.getTitle() + "\"] open");
        for (FailableRunnable<Exception> listener : this.openListeners) {
            EUtils.catchWithDialog(this, listener);
        }
    }

    protected void fireClosingEvent() {
        System.err.println("[" + System.identityHashCode(this) + " \"" + this.getTitle() + "\"] closing");
        this.closing = true;
        for (FailableRunnable<Exception> listener : this.closingListeners) {
            EUtils.catchWithDialog(this, listener);
        }
    }

    protected void fireClosedEvent() {
        System.err.println("[" + System.identityHashCode(this) + " \"" + this.getTitle() + "\"] closed (" + this.closing + ")");
        if (this.parent != null) {
            this.parent.children.remove(this);
            this.parent = null;
        }
        for (FailableRunnable<Exception> listener : this.closedListeners) {
            EUtils.catchWithDialog(this, listener);
        }
        if (this.closing) {
            for (FailableRunnable<Exception> listener : this.closedByUserListeners) {
                EUtils.catchWithDialog(this, listener);
            }
        }
    }

    public ENavigatorPane findNavPane() {
        if (this.parent != null) {
            return this.parent.findNavPane();
        }
        return null;
    }

    public JFrame intoWindow() {
        if (this.opened) {
            throw new IllegalStateException();
        }
        this.opened = true;
        JFrame frame = new JFrame();
        frame.setTitle(this.title);
        frame.setIconImage(this.icon);
        if (this.windowSize != null) {
            frame.setSize(this.windowSize);
        }
        if (this.windowMinSize != null) {
            frame.setMinimumSize(this.windowMinSize);
        }
        frame.setResizable(this.resizable);
        if (this.maximized) {
            frame.setExtendedState(6);
        }
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                EFrame.this.fireOpenEvent();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                EFrame.this.fireClosingEvent();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                EFrame.this.fireClosedEvent();
            }
        });
        this.initRootPane(frame.getRootPane());
        frame.getRootPane().setGlassPane(this.glass);
        if (this.packing) {
            frame.pack();
        }
        frame.setLocationRelativeTo(null);
        this.addChangeListener(() -> frame.setTitle(this.title));
        this.frameInstance = frame;
        return frame;
    }

    public JDialog intoDialog(Component parent) {
        return this.intoDialog(parent, false);
    }

    public JDialog intoModalDialog(Component parent) {
        return this.intoDialog(parent, true);
    }

    public JDialog intoDialog(Component parentComponent, boolean modal) {
        if (this.opened) {
            throw new IllegalStateException();
        }
        this.opened = true;
        Window parentWindow = SwingUtilities.windowForComponent(parentComponent);
        JDialog dialog = new JDialog(parentWindow);
        dialog.setTitle(this.title);
        dialog.setIconImage(this.icon);
        if (this.windowSize != null) {
            dialog.setSize(this.windowSize);
        }
        dialog.setResizable(this.resizable);
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                EFrame.this.fireOpenEvent();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                EFrame.this.fireClosingEvent();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                EFrame.this.fireClosedEvent();
            }
        });
        if (modal) {
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        }
        this.initRootPane(dialog.getRootPane());
        dialog.getRootPane().setGlassPane(this.glass);
        if (this.packing) {
            dialog.pack();
        }
        dialog.setLocationRelativeTo(parentWindow);
        this.addChangeListener(() -> dialog.setTitle(this.title));
        this.dialogInstance = dialog;
        return dialog;
    }

    public JRootPane intoRootPane() {
        if (this.opened) {
            throw new IllegalStateException();
        }
        this.opened = true;
        JRootPane root = new JRootPane();
        this.initRootPane(root);
        root.getRootPane().setGlassPane(this.glass);
        return root;
    }

    public void openPage(EFrame parent) {
        ENavigatorPane nav = parent.findNavPane();
        if (nav == null) {
            throw new IllegalStateException();
        }
        this.setParent(parent);
        JRootPane root = this.intoRootPane();
        nav.push(this, root);
        this.fireOpenEvent();
    }

    public void openPage(EFrame parent, FailableRunnable<Exception> run) {
        this.addClosedByUserListener(run);
        this.openPage(parent);
    }

    public void openInnerModal(EFrame parent) {
        JInternalFrame frame = new JInternalFrame();
        frame.setTitle(this.title);
        frame.setFrameIcon(this.icon != null ? new ImageIcon(this.icon) : null);
        if (this.windowSize != null) {
            frame.setSize(this.windowSize);
        }
        frame.setMaximizable(this.resizable);
        frame.setClosable(true);
        frame.setResizable(this.resizable);
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                EFrame.this.fireClosingEvent();
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                EFrame.this.fireClosedEvent();
            }
        });
        this.initRootPane(frame.getRootPane());
        parent.glass.add((Component)this.glass, JLayeredPane.MODAL_LAYER);
        if (this.packing) {
            frame.pack();
        }
        this.addChangeListener(() -> frame.setTitle(this.title));
        this.setParent(parent);
        parent.openInnerModal(frame);
        this.internalFrameInstance = frame;
        this.fireOpenEvent();
    }

    public void openInnerModal(EFrame parent, FailableRunnable<Exception> run) {
        this.addClosedByUserListener(run);
        this.openInnerModal(parent);
    }

    private void setParent(EFrame parent) {
        if (this.parent != null) {
            throw new IllegalStateException();
        }
        this.parent = parent;
        this.parent.children.add(this);
    }

    private void initRootPane(JRootPane pane) {
        if (this.menuBar != null) {
            pane.setJMenuBar(this.menuBar);
        }
        pane.getContentPane().add(this);
        if (this.defaultButton != null) {
            pane.setDefaultButton(this.defaultButton);
        }
        this.glass = new JLayeredPane(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doLayout() {
                Object object = this.getTreeLock();
                synchronized (object) {
                    int w = this.getWidth();
                    int h = this.getHeight();
                    for (Component c : this.getComponents()) {
                        c.setBounds(0, 0, w, h);
                    }
                }
                super.doLayout();
            }
        };
        this.glass.setVisible(false);
        this.glass.setOpaque(false);
        this.glass.setFocusable(true);
        this.glass.setLayout(null);
        this.glass.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                ev.consume();
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                ev.consume();
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
                ev.consume();
            }
        });
        this.glass.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent ev) {
                ev.consume();
            }

            @Override
            public void keyReleased(KeyEvent ev) {
                ev.consume();
            }

            @Override
            public void keyTyped(KeyEvent ev) {
                ev.consume();
            }
        });
        this.desktop = new JDesktopPane();
        this.desktop.setOpaque(false);
        this.glass.add((Component)this.desktop, JLayeredPane.DEFAULT_LAYER);
    }

    protected void openInnerModal(JInternalFrame frame) {
        Dimension desktopSize = this.desktop.getSize();
        Dimension size = frame.getSize();
        frame.setLocation(desktopSize.width / 2 - size.width / 2, desktopSize.height / 2 - size.height / 2);
        frame.setVisible(true);
        this.desktop.add(frame);
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                if (EFrame.this.desktop.getAllFrames().length == 0) {
                    EFrame.this.glass.setVisible(false);
                }
            }
        });
        this.glass.setVisible(true);
        this.glass.requestFocus();
        EUtils.catchSilently(() -> frame.setSelected(true));
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean user) {
        if (this.closing) {
            throw new IllegalStateException();
        }
        if (user) {
            this.fireClosingEvent();
        }
        for (EFrame c : new ArrayList<EFrame>(this.children)) {
            c.close(false);
        }
        if (this.frameInstance != null) {
            this.frameInstance.dispose();
        } else if (this.dialogInstance != null) {
            this.dialogInstance.dispose();
        } else if (this.internalFrameInstance != null) {
            this.internalFrameInstance.dispose();
        } else {
            if (this.parent == null) {
                throw new IllegalStateException();
            }
            ENavigatorPane nav = this.parent.findNavPane();
            if (nav == null) {
                throw new IllegalStateException();
            }
            nav.pop(this);
            this.fireClosedEvent();
        }
    }
}

