/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.gui.EFrame;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayDeque;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class ENavigatorPane
extends EFrame {
    private static final long serialVersionUID = 1L;
    private ArrayDeque<EFrame> pages = new ArrayDeque();
    private ArrayDeque<JRootPane> pages_pane = new ArrayDeque();
    private JLabel lblPath;
    private JPanel content;
    private CardLayout contentCard;

    public ENavigatorPane() {
        this.setLayout(new BorderLayout());
        this.lblPath = new JLabel();
        this.content = new JPanel();
        this.add((Component)this.content, "Center");
        this.contentCard = new CardLayout();
        this.content.setLayout(this.contentCard);
    }

    public EFrame getCurrentPage() {
        return this.pages.isEmpty() ? null : this.pages.getLast();
    }

    public List<EFrame> getPath() {
        return this.pages.stream().collect(Collectors.toList());
    }

    public void push(EFrame page, JRootPane root) {
        this.pages.addLast(page);
        this.pages_pane.addLast(root);
        this.content.add(root);
        this.contentCard.next(this.content);
        page.addChangeListener(() -> this.update());
        this.pages.getLast().requestFocusInWindow();
        this.update();
    }

    public void pop(EFrame page) {
        if (this.pages.isEmpty() || this.pages.getLast() != page) {
            throw new IllegalArgumentException();
        }
        this.pages.removeLast();
        JRootPane pane = this.pages_pane.removeLast();
        this.contentCard.previous(this.content);
        this.content.remove(pane);
        if (!this.pages.isEmpty()) {
            this.pages.getLast().requestFocusInWindow();
        }
        this.update();
    }

    private void update() {
        EFrame pg = this.getCurrentPage();
        this.setTitle(pg == null ? "" : pg.getTitle());
        this.lblPath.setText(this.pages.stream().map(p -> p.getTitle()).collect(Collectors.joining(" > ")));
    }

    @Override
    public ENavigatorPane findNavPane() {
        return this;
    }
}

